/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.health.analytics.HealthCheckAnalyticsEvent;
import com.atlassian.jira.startup.mode.StartupMode;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractHeliumAnalyticsEvent {
    private final String eventNameSuffix;
    private LicenseType licenseType = LicenseType.UNKNOWN;
    private StartupMode startupMode = StartupMode.UNKNOWN;

    protected AbstractHeliumAnalyticsEvent(String eventNameSuffix) {
        this.eventNameSuffix = Objects.requireNonNull(eventNameSuffix);
        if (StringUtils.isBlank((CharSequence)this.eventNameSuffix)) {
            throw new RuntimeException("Empty suffix");
        }
    }

    @EventName
    public String getEventName() {
        return "johnsonpage.helium." + this.eventNameSuffix;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(LicenseType licenseType) {
        this.licenseType = licenseType;
    }

    public StartupMode getStartupMode() {
        return this.startupMode;
    }

    public void setStartupMode(StartupMode startupMode) {
        this.startupMode = startupMode;
    }

    public String getJiraRunId() {
        return HealthCheckAnalyticsEvent.JIRA_RUN_ID;
    }

    public static enum LicenseType {
        UNKNOWN,
        SERVER,
        DC;

    }
}

