/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.InvalidDatabaseDriverException;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class JdbcDriverHealthCheck
extends HealthCheckTemplate {
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/KTsWN");

    public JdbcDriverHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.PRE_DATABASE_LAUNCH));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        return this.performCheck((DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class));
    }

    @VisibleForTesting
    protected List<HealthCheckResult> performCheck(DatabaseConfigurationManager dbcm) {
        try {
            dbcm.getDatabaseConfiguration();
        }
        catch (InvalidDatabaseDriverException e) {
            return this.getErrorMessageForDatabase(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private List<HealthCheckResult> getErrorMessageForDatabase(InvalidDatabaseDriverException driverException) {
        return DatabaseType.forJdbcDriverClassName(driverException.driverClassName()).map(this::failWithoutDriver).orElseGet(() -> this.unknownDbType(driverException));
    }

    private List<HealthCheckResult> failWithoutDriver(DatabaseType databaseType) {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter().append(HealthCheckMessageFormatter.string("We couldn't find a driver for your " + databaseType.getDisplayName() + " database. You'll need to download and install the correct driver to allow JIRA to start and connect to your database.")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on installing database drivers."));
        return this.fail(messageFormatter, KB_URL);
    }

    private List<HealthCheckResult> unknownDbType(InvalidDatabaseDriverException driverException) {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter().append(HealthCheckMessageFormatter.string("We could not identify the type of database from the driver class name '" + driverException.driverClassName() + "'"));
        return this.fail(messageFormatter, null);
    }

    private List<HealthCheckResult> fail(HealthCheckMessageFormatter messageFormatter, @Nullable URL kbUrl) {
        return HealthCheckResult.fail(this, new Event(JohnsonEventType.DATABASE.eventType(), "Missing Database Driver", messageFormatter.toHtml(), JohnsonEventLevel.FATAL.eventLevel()), kbUrl, "jdbc-driver-error", messageFormatter.toText());
    }
}

