/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.InvalidDatabaseDriverException;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSSQLDriverMigrationHealthCheck
extends HealthCheckTemplate {
    private static final Logger log = LoggerFactory.getLogger(MSSQLDriverMigrationHealthCheck.class);
    private static final String HEALTHCHECK_DESCRIPTION = "We've shipped a new driver for your database. You'll need to run the JIRA config tool (bin/config.bat or config.sh) and click Save, it will make the necessary changes for you.";

    public MSSQLDriverMigrationHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.PRE_DATABASE_LAUNCH));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        DatabaseConfigurationManager databaseConfigurationManager = (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
        return this.performCheck(databaseConfigurationManager);
    }

    @VisibleForTesting
    protected List<HealthCheckResult> performCheck(DatabaseConfigurationManager databaseConfigurationManager) {
        try {
            DatabaseConfig databaseConfig = databaseConfigurationManager.getDatabaseConfiguration();
        }
        catch (InvalidDatabaseDriverException e) {
            DatabaseType databaseType = DatabaseType.SQL_SERVER;
            if (databaseType.getDeprecatedJdbcDriverClassNames().contains(e.driverClassName())) {
                return HealthCheckResult.fail(this, new Event(JohnsonEventType.DATABASE.eventType(), "Update the JDBC URL", HEALTHCHECK_DESCRIPTION, JohnsonEventLevel.FATAL.eventLevel()), UrlBuilder.createURL((String)"https://confluence.atlassian.com/jirakb/updating-jdbc-url-for-microsoft-sql-server-934718842.html"), "mssql-driver-error", HEALTHCHECK_DESCRIPTION);
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            log.debug("Exception when reading database configuration: ", (Throwable)e);
        }
        return Collections.emptyList();
    }
}

