/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.web;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.health.HealthChecks;
import com.atlassian.jira.health.web.JohnsonEventCollectionSerializer;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.util.johnson.JohnsonEventPredicates;
import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventPredicates;
import com.atlassian.johnson.event.EventType;
import com.atlassian.johnson.setup.SetupConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;

public final class JohnsonPageDataProvider {
    static final String HIDE_EVENT_DETAILS = "hide.system.error.details";
    private static final Predicate<Event> IS_REINDEX_EVENT = EventPredicates.type((EventType)EventType.get((String)"reindex"));
    private final JohnsonEventCollectionSerializer eventCollectionSerializer;
    private final JohnsonEventContainer johnsonContainer;
    private final SetupConfig setupConfig;
    private final Supplier<Boolean> healthCheckCompleteSupplier;
    private final Supplier<Optional<GlobalPermissionManager>> globalPermissionManagerSupplier;

    @VisibleForTesting
    JohnsonPageDataProvider(JohnsonEventContainer johnsonContainer, JohnsonEventCollectionSerializer eventCollectionSerializer, Supplier<Optional<GlobalPermissionManager>> globalPermissionManagerSupplier, SetupConfig setupConfig, Supplier<Boolean> healthCheckCompleteSupplier) {
        this.johnsonContainer = johnsonContainer;
        this.eventCollectionSerializer = eventCollectionSerializer;
        this.globalPermissionManagerSupplier = globalPermissionManagerSupplier;
        this.setupConfig = setupConfig;
        this.healthCheckCompleteSupplier = healthCheckCompleteSupplier;
    }

    public static JohnsonPageDataProvider createInstance(@Nonnull ServletContext context) {
        return new JohnsonPageDataProvider(Johnson.getEventContainer((ServletContext)context), new JohnsonEventCollectionSerializer(context.getContextPath()), ComponentAccessor.safeSupplierOf(GlobalPermissionManager.class), Johnson.getConfig().getSetupConfig(), HealthChecks::isComplete);
    }

    @Nonnull
    public JsonObject asJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("canAuthoriseUsers", Boolean.valueOf(this.canAuthoriseUsers()));
        json.addProperty("checksComplete", Boolean.valueOf(this.areHealthChecksComplete()));
        if (StringUtils.isBlank((CharSequence)JiraSystemProperties.getInstance().getProperty(HIDE_EVENT_DETAILS))) {
            json.add("events", (JsonElement)this.eventCollectionSerializer.toJSON(this.johnsonContainer.getEvents()));
        } else if (this.johnsonContainer.hasEvent(IS_REINDEX_EVENT)) {
            json.add("events", (JsonElement)this.eventCollectionSerializer.toJSON(this.johnsonContainer.getEvents(IS_REINDEX_EVENT)));
        } else if (this.startupBlocked()) {
            json.addProperty("errorsPresentButHidden", Boolean.valueOf(true));
        }
        return json;
    }

    private boolean areHealthChecksComplete() {
        return this.healthCheckCompleteSupplier.get();
    }

    private boolean canAuthoriseUsers() {
        if (!this.globalPermissionManagerSupplier.get().isPresent()) {
            return false;
        }
        try {
            return this.setupConfig.isSetup();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean startupBlocked() {
        return this.johnsonContainer.hasEvent(JohnsonEventPredicates.blocksStartup());
    }
}

