/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrlBuilder;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.help.HelpUrlsParser;
import com.atlassian.jira.help.ImmutableHelpUrls;
import com.atlassian.jira.help.LocalHelpUrls;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

class DefaultHelpUrlsParser
implements HelpUrlsParser {
    private static final String URL_SUFFIX = ".url";
    private static final String ALT_SUFFIX = ".alt";
    private static final String DESCRIPTION_SUFFIX = ".description";
    private static final String TITLE_SUFFIX = ".title";
    private static final String DEFAULT_KEY = "default";
    private final HelpUrlBuilder.Factory helpUrlBuilderFactory;
    private final String defaultUrl;
    private final String defaultTitle;
    private final LocalHelpUrls localUrls;

    DefaultHelpUrlsParser(HelpUrlBuilder.Factory helpUrlBuilderFactory, LocalHelpUrls localUrls, String defaultUrl, String defaultTitle) {
        this.localUrls = (LocalHelpUrls)Assertions.notNull((String)"localUrls", (Object)localUrls);
        this.helpUrlBuilderFactory = (HelpUrlBuilder.Factory)Assertions.notNull((String)"helpUrlBuilderFactory", (Object)helpUrlBuilderFactory);
        this.defaultUrl = StringUtils.trimToNull((String)defaultUrl);
        this.defaultTitle = StringUtils.trimToNull((String)defaultTitle);
    }

    @Nonnull
    public HelpUrlsParser onDemand(boolean onDemand) {
        if (!onDemand) {
            return this;
        }
        return new DefaultHelpUrlsParser(this.helpUrlBuilderFactory, this.localUrls, this.defaultUrl, this.defaultTitle);
    }

    @Nonnull
    public HelpUrlsParser defaultUrl(String url, String title) {
        return new DefaultHelpUrlsParser(this.helpUrlBuilderFactory, this.localUrls, url, title);
    }

    @Nonnull
    public HelpUrls parse(@Nonnull Properties properties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            builder.put((Object)key.toString(), (Object)value.toString());
        }
        return this.parse((Map<String, String>)builder.build());
    }

    @Nonnull
    public HelpUrls parse(@Nonnull Properties externalProperties, @Nonnull Properties internalProperties) {
        HelpUrls urls = this.parse(externalProperties);
        Iterable<HelpUrl> internal = this.localUrls.parse(internalProperties);
        return new ImmutableHelpUrls(urls.getDefaultUrl(), Iterables.concat(internal, (Iterable)urls));
    }

    @Nonnull
    public HelpUrls parse(@Nonnull Map<String, String> properties) {
        return new LookupInvocation(properties).execute();
    }

    @Nonnull
    public HelpUrls parse(@Nonnull Map<String, String> userProperties, @Nonnull Map<String, String> adminProperties) {
        return ImmutableHelpUrls.merge(new LookupInvocation(userProperties).execute(), new LookupInvocation(adminProperties).execute());
    }

    private class LookupInvocation {
        private Map<String, String> properties;
        private HelpUrlBuilder template;

        private LookupInvocation(Map<String, String> properties) {
            this.properties = properties;
        }

        private ImmutableHelpUrls execute() {
            this.properties = this.flattenNamespaces(this.properties);
            this.template = this.createDefaultUrl();
            this.template = this.loadHelpPath(DefaultHelpUrlsParser.DEFAULT_KEY);
            HelpUrl defaultUrl = this.template.build();
            return new ImmutableHelpUrls(defaultUrl, this.parseUrls());
        }

        private HelpUrlBuilder createDefaultUrl() {
            return DefaultHelpUrlsParser.this.helpUrlBuilderFactory.get(this.properties.get("url-prefix"), this.properties.get("url-suffix")).key(DefaultHelpUrlsParser.DEFAULT_KEY).url(DefaultHelpUrlsParser.this.defaultUrl).title(DefaultHelpUrlsParser.this.defaultTitle);
        }

        private Map<String, String> flattenNamespaces(Map<String, String> mapWithNamespace) {
            HashMap result = Maps.newHashMap();
            HashMap overrides = Maps.newHashMap();
            for (Map.Entry<String, String> entry : mapWithNamespace.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || value == null) continue;
                result.put(key, value);
            }
            result.putAll(overrides);
            return result;
        }

        private Iterable<HelpUrl> parseUrls() {
            ArrayList newPaths = Lists.newArrayList();
            for (String property : this.properties.keySet()) {
                if (!StringUtils.endsWith((CharSequence)property, (CharSequence)DefaultHelpUrlsParser.URL_SUFFIX)) continue;
                String key = StringUtils.removeEnd((String)property, (String)DefaultHelpUrlsParser.URL_SUFFIX);
                newPaths.add(this.loadHelpPath(key).build());
            }
            return newPaths;
        }

        private HelpUrlBuilder loadHelpPath(String key) {
            String title;
            String description;
            String alt;
            HelpUrlBuilder builder = this.template.copy().key(key);
            String url = this.properties.get(key + DefaultHelpUrlsParser.URL_SUFFIX);
            if (url != null) {
                builder = builder.url(url);
            }
            if ((alt = this.properties.get(key + DefaultHelpUrlsParser.ALT_SUFFIX)) != null) {
                builder = builder.alt(alt);
            }
            if ((description = this.properties.get(key + DefaultHelpUrlsParser.DESCRIPTION_SUFFIX)) != null) {
                builder = builder.description(description);
            }
            if ((title = this.properties.get(key + DefaultHelpUrlsParser.TITLE_SUFFIX)) != null) {
                builder = builder.title(title);
            }
            return builder;
        }
    }
}

