/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.event.ClearSpecCacheEvent;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.i18n.JiraI18nResolver;
import com.atlassian.jira.i18n.terminology.TerminologyCacheClearedEvent;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GadgetSpecsCacheService
implements InitializingComponent {
    private static final Logger log = LoggerFactory.getLogger(GadgetSpecsCacheService.class);
    private final EventPublisher eventPublisher;

    public GadgetSpecsCacheService(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void afterInstantiation() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onTerminologyCacheClearedEvent(TerminologyCacheClearedEvent event) {
        Optional<JiraI18nResolver> jiraI18nResolver = this.getJiraI18nResolver();
        jiraI18nResolver.ifPresent(JiraI18nResolver::clearCache);
        this.eventPublisher.publish((Object)new ClearSpecCacheEvent());
    }

    private Optional<JiraI18nResolver> getJiraI18nResolver() {
        I18nResolver i18nResolver = (I18nResolver)ComponentAccessor.getOSGiComponentInstanceOfType(I18nResolver.class);
        if (i18nResolver instanceof JiraI18nResolver) {
            return Optional.of((JiraI18nResolver)i18nResolver);
        }
        log.error("On '{}' '{}' cache has not been clear because object does not exist in any Spring or OSGi context. It could cause that gadget specs will be not invalidated properly.", (Object)TerminologyCacheClearedEvent.class.getSimpleName(), (Object)JiraI18nResolver.class.getSimpleName());
        return Optional.empty();
    }
}

