/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.i18n.terminology.TerminologyEntryDao;
import com.atlassian.jira.model.querydsl.NomenclatureEntryDTO;
import com.atlassian.jira.model.querydsl.QNomenclatureEntry;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class QueryDSLTerminologyEntryDao
implements TerminologyEntryDao {
    private final QueryDslAccessor queryDslAccessor;

    public QueryDSLTerminologyEntryDao(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    public NomenclatureEntryDTO getTerminologyEntry(String originalName) {
        return this.queryDslAccessor.executeQuery(dbConnection -> (NomenclatureEntryDTO)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QNomenclatureEntry.NOMENCLATURE_ENTRY).from((Expression)QNomenclatureEntry.NOMENCLATURE_ENTRY)).where((Predicate)QNomenclatureEntry.NOMENCLATURE_ENTRY.originalName.eq((Object)originalName))).orderBy(QNomenclatureEntry.NOMENCLATURE_ENTRY.timestamp.desc())).fetchFirst());
    }

    @Override
    public Collection<NomenclatureEntryDTO> getAllTerminologyEntries() {
        return this.getLatestEntriesForOriginalNames(this.getAllEntries());
    }

    @Override
    public Collection<NomenclatureEntryDTO> getHistoricalTerminologyEntries() {
        return this.getAllEntries();
    }

    private List<NomenclatureEntryDTO> getAllEntries() {
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)dbConnection.newSqlQuery().select((Expression)QNomenclatureEntry.NOMENCLATURE_ENTRY).from((Expression)QNomenclatureEntry.NOMENCLATURE_ENTRY)).fetch());
    }

    private Collection<NomenclatureEntryDTO> getLatestEntriesForOriginalNames(List<NomenclatureEntryDTO> allEntries) {
        return allEntries.stream().collect(Collectors.toMap(entry -> entry.getOriginalName(), Function.identity(), (e1, e2) -> e1.getTimestamp() > e2.getTimestamp() ? e1 : e2)).values();
    }

    @Override
    public void setTerminologyEntries(Collection<NomenclatureEntryDTO> terminologyEntryDTOs) {
        this.queryDslAccessor.withNewConnection().execute(dbConnection -> {
            dbConnection.setAutoCommit(false);
            terminologyEntryDTOs.forEach(dto -> dbConnection.insert(QNomenclatureEntry.NOMENCLATURE_ENTRY).populate(dto).executeWithId());
            dbConnection.commit();
        });
    }
}

