/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import com.atlassian.jira.i18n.terminology.TerminologyEntry;
import com.atlassian.jira.i18n.terminology.TerminologyEntryDao;
import com.atlassian.jira.i18n.terminology.TerminologyEntryReader;
import com.atlassian.jira.i18n.terminology.TerminologyUtils;
import com.atlassian.jira.i18n.terminology.ValidatedTerminologyEntryImpl;
import com.atlassian.jira.model.querydsl.NomenclatureEntryDTO;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TerminologyEntryReaderImpl
implements TerminologyEntryReader {
    private final TerminologyEntryDao terminologyEntryDao;

    public TerminologyEntryReaderImpl(TerminologyEntryDao terminologyEntryDao) {
        this.terminologyEntryDao = terminologyEntryDao;
    }

    public Optional<TerminologyEntry> getTerminologyEntry(String originalName) {
        String canonicalOriginalName = TerminologyUtils.canonicalizeEntryName(originalName);
        Optional<ValidatedTerminologyEntryImpl.AllowedOriginalName> allowedOriginalName = ValidatedTerminologyEntryImpl.AllowedOriginalName.fromSingular(canonicalOriginalName);
        if (!allowedOriginalName.isPresent()) {
            return Optional.empty();
        }
        NomenclatureEntryDTO terminologyEntryDTO = this.terminologyEntryDao.getTerminologyEntry(canonicalOriginalName);
        if (terminologyEntryDTO != null) {
            TerminologyEntry terminologyEntry = ValidatedTerminologyEntryImpl.fromDTO(terminologyEntryDTO);
            return Optional.of(terminologyEntry);
        }
        return Optional.of(this.getDefaultTerminologyEntry(allowedOriginalName.get()));
    }

    public Collection<TerminologyEntry> getAllTerminologyEntries() {
        Map<String, TerminologyEntry> storedEntries = this.terminologyEntryDao.getAllTerminologyEntries().stream().map(ValidatedTerminologyEntryImpl::fromDTO).collect(Collectors.toMap(TerminologyEntry::getOriginalName, Function.identity()));
        return this.ensureTerminologyEntryForEachAllowedOriginalName(storedEntries);
    }

    public Collection<TerminologyEntry> getHistoricalTerminologyEntries(String originalName) {
        return this.terminologyEntryDao.getHistoricalTerminologyEntries().stream().filter(entry -> entry.getOriginalName().equals(originalName)).map(ValidatedTerminologyEntryImpl::fromDTO).collect(Collectors.toList());
    }

    private Collection<TerminologyEntry> ensureTerminologyEntryForEachAllowedOriginalName(Map<String, TerminologyEntry> storedTerminologyEntries) {
        return (Collection)Arrays.stream(ValidatedTerminologyEntryImpl.AllowedOriginalName.values()).map(allowedOriginalName -> storedTerminologyEntries.getOrDefault(allowedOriginalName.getSingular(), this.getDefaultTerminologyEntry((ValidatedTerminologyEntryImpl.AllowedOriginalName)((Object)allowedOriginalName)))).collect(ImmutableList.toImmutableList());
    }

    private TerminologyEntry getDefaultTerminologyEntry(ValidatedTerminologyEntryImpl.AllowedOriginalName originalName) {
        return new ValidatedTerminologyEntryImpl(originalName, originalName.getSingular(), originalName.getPlural());
    }
}

