/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import com.atlassian.jira.i18n.terminology.TerminologyEntry;
import com.atlassian.jira.i18n.terminology.TerminologyEntryDao;
import com.atlassian.jira.i18n.terminology.TerminologyEntryWriter;
import com.atlassian.jira.i18n.terminology.TerminologyUtils;
import com.atlassian.jira.i18n.terminology.ValidatedTerminologyEntryImpl;
import com.atlassian.jira.jql.util.JqlStringSupportImpl;
import com.atlassian.jira.model.querydsl.NomenclatureEntryDTO;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TerminologyEntryValidator {
    static final int MAX_NAME_LENGTH = 100;
    static final int MIN_NAME_LENGTH = 1;
    private static final String LETTERS_NUMBERS_AND_WHITESPACES = "^[A-Za-z0-9 ]+";
    private final TerminologyEntryDao terminologyEntryDao;

    public TerminologyEntryValidator(TerminologyEntryDao terminologyEntryDao) {
        this.terminologyEntryDao = terminologyEntryDao;
    }

    public TerminologyEntryWriter.TerminologyValidationResult validateNewTerminologyEntries(Collection<TerminologyEntry> terminologyEntries) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ImmutableList.Builder validatedTerminologyEntries = ImmutableList.builder();
        terminologyEntries.stream().forEach(arg_0 -> this.lambda$validateNewTerminologyEntries$1((ErrorCollection)errorCollection, validatedTerminologyEntries, arg_0));
        this.crossValidateNewNames(terminologyEntries, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return TerminologyEntryWriter.TerminologyValidationResult.error((ErrorCollection)errorCollection);
        }
        return TerminologyEntryWriter.TerminologyValidationResult.ok((Collection)validatedTerminologyEntries.build());
    }

    private void crossValidateNewNames(Collection<TerminologyEntry> terminologyEntries, ErrorCollection errorCollection) {
        Map<String, List<String>> singularNames = this.getGroupedNames(terminologyEntries, terminologyEntry -> terminologyEntry.getNewName());
        Map<String, List<String>> pluralNames = this.getGroupedNames(terminologyEntries, terminologyEntry -> terminologyEntry.getNewNamePlural());
        if (singularNames.entrySet().stream().anyMatch(entry -> ((List)entry.getValue()).size() > 1)) {
            errorCollection.addError("newName", "Names must be unique.", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (pluralNames.entrySet().stream().anyMatch(entry -> ((List)entry.getValue()).size() > 1)) {
            errorCollection.addError("newNamePlural", "Names must be unique.", ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private Map<String, List<String>> getGroupedNames(Collection<TerminologyEntry> terminologyEntries, Function<TerminologyEntry, String> nameMappingFunction) {
        return terminologyEntries.stream().filter(terminologyEntry -> !Strings.isNullOrEmpty((String)TerminologyUtils.canonicalizeEntryName(terminologyEntry.getNewName()))).map(terminologyEntry -> (String)nameMappingFunction.apply((TerminologyEntry)terminologyEntry)).collect(Collectors.groupingBy(Function.identity()));
    }

    private void validateOriginalName(@Nullable String originalName, ErrorCollection errorCollection) {
        if (Strings.isNullOrEmpty((String)originalName)) {
            errorCollection.addError("originalName", "Original name must not be null, empty or composed only of whitespaces.", ErrorCollection.Reason.VALIDATION_FAILED);
            return;
        }
        if (this.isOriginalNameAllowed(originalName)) {
            errorCollection.addError("originalName", String.format("Original name '%s' cannot be changed.", originalName), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private void validateNewName(@Nullable String originalName, @Nullable String newName, ErrorCollection errorCollection, NewNameField newNameField) {
        if (Strings.isNullOrEmpty((String)newName)) {
            errorCollection.addError(newNameField.getFieldName(), newNameField.getFieldName() + " must not be null, empty or composed only of whitespaces.", ErrorCollection.Reason.VALIDATION_FAILED);
            return;
        }
        if (!this.containsOnlyLettersNumbersAndWhitespaces(newName)) {
            errorCollection.addError(newNameField.getFieldName(), newNameField.getFieldName() + " can be composed only of letters, numbers and whitespaces.", ErrorCollection.Reason.VALIDATION_FAILED);
            return;
        }
        if (this.isNewNameLengthNotValid(newName)) {
            errorCollection.addError(newNameField.getFieldName(), String.format("Trimmed %s: '%s' length is shorter than %d or longer than %d.", newNameField.getFieldName(), newName, 1, 100), ErrorCollection.Reason.VALIDATION_FAILED);
            return;
        }
        if (this.isJQLKeyword(newName)) {
            errorCollection.addError(newNameField.getFieldName(), String.format("%s: '%s' is a JQL keyword.", newNameField.getFieldName(), newName), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (originalName == null) {
            return;
        }
        if (this.isForbiddenChange(originalName, newName)) {
            errorCollection.addError(newNameField.getFieldName(), String.format("'%s' %s cannot be changed to '%s'.", originalName, newNameField.getFieldName(), newName), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (this.isAlreadyUsed(originalName, newName, newNameField)) {
            errorCollection.addError(newNameField.getFieldName(), String.format("%s: '%s' is already used.", newNameField.getFieldName(), newName), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private boolean isAlreadyUsed(String originalName, String newName, NewNameField newNameField) {
        Function<NomenclatureEntryDTO, String> newNameProvider = newNameField.isPlural() ? NomenclatureEntryDTO::getNewNamePlural : NomenclatureEntryDTO::getNewName;
        return this.terminologyEntryDao.getAllTerminologyEntries().stream().filter(terminologyEntryDTO -> !terminologyEntryDTO.getOriginalName().equalsIgnoreCase(originalName)).map(newNameProvider).anyMatch(newName::equalsIgnoreCase);
    }

    private boolean isOriginalNameAllowed(String originalName) {
        return Arrays.stream(ValidatedTerminologyEntryImpl.AllowedOriginalName.values()).map(Enum::name).noneMatch(originalName::equalsIgnoreCase);
    }

    private boolean isForbiddenChange(String originalName, String newName) {
        return ForbiddenChange.exists(originalName, newName);
    }

    private boolean isNewNameLengthNotValid(String newName) {
        return newName.length() > 100 || newName.length() < 1;
    }

    private boolean containsOnlyLettersNumbersAndWhitespaces(String newName) {
        return newName.matches(LETTERS_NUMBERS_AND_WHITESPACES);
    }

    private boolean isJQLKeyword(String newName) {
        return JqlStringSupportImpl.isReservedString(newName);
    }

    private /* synthetic */ void lambda$validateNewTerminologyEntries$1(ErrorCollection errorCollection, ImmutableList.Builder validatedTerminologyEntries, TerminologyEntry terminologyEntry) {
        String canonicalOriginalName = TerminologyUtils.canonicalizeEntryName(terminologyEntry.getOriginalName());
        String canonicalNewName = TerminologyUtils.canonicalizeEntryName(terminologyEntry.getNewName());
        String canonicalNewNamePlural = TerminologyUtils.canonicalizeEntryName(terminologyEntry.getNewNamePlural());
        this.validateOriginalName(canonicalOriginalName, errorCollection);
        this.validateNewName(canonicalOriginalName, canonicalNewName, errorCollection, NewNameField.NEW_NAME);
        this.validateNewName(canonicalOriginalName, canonicalNewNamePlural, errorCollection, NewNameField.NEW_NAME_PLURAL);
        Optional<ValidatedTerminologyEntryImpl.AllowedOriginalName> allowedOriginalName = ValidatedTerminologyEntryImpl.AllowedOriginalName.fromSingular(canonicalOriginalName);
        allowedOriginalName.ifPresent(originalName -> validatedTerminologyEntries.add((Object)new ValidatedTerminologyEntryImpl((ValidatedTerminologyEntryImpl.AllowedOriginalName)((Object)((Object)allowedOriginalName.get())), canonicalNewName, canonicalNewNamePlural)));
    }

    private static enum NewNameField {
        NEW_NAME("newName"),
        NEW_NAME_PLURAL("newNamePlural");

        private final String fieldName;

        private NewNameField(String fieldName) {
            this.fieldName = fieldName;
        }

        private String getFieldName() {
            return this.fieldName;
        }

        private boolean isPlural() {
            return this == NEW_NAME_PLURAL;
        }
    }

    private static enum ForbiddenChange {
        SPRINT_TO_EPIC(ValidatedTerminologyEntryImpl.AllowedOriginalName.SPRINT.name(), ValidatedTerminologyEntryImpl.AllowedOriginalName.EPIC.name()),
        SPRINT_TO_EPICS(ValidatedTerminologyEntryImpl.AllowedOriginalName.SPRINT.name(), ValidatedTerminologyEntryImpl.AllowedOriginalName.EPIC.getPlural()),
        EPIC_TO_SPRINT(ValidatedTerminologyEntryImpl.AllowedOriginalName.EPIC.name(), ValidatedTerminologyEntryImpl.AllowedOriginalName.SPRINT.name()),
        EPIC_TO_SPRINTS(ValidatedTerminologyEntryImpl.AllowedOriginalName.EPIC.name(), ValidatedTerminologyEntryImpl.AllowedOriginalName.SPRINT.getPlural());

        private final String originalName;
        private final String newName;

        private ForbiddenChange(String originalName, String newName) {
            this.originalName = originalName;
            this.newName = newName;
        }

        static boolean exists(String originalName, String newName) {
            return Arrays.stream(ForbiddenChange.values()).anyMatch(forbiddenChange -> originalName.equalsIgnoreCase(forbiddenChange.originalName) && newName.equalsIgnoreCase(forbiddenChange.newName));
        }
    }
}

