/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalComment;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.CommentParser;
import com.atlassian.jira.imports.project.parser.CommentParserImpl;
import com.atlassian.jira.imports.project.transformer.CommentTransformer;
import com.atlassian.jira.imports.project.transformer.CommentTransformerImpl;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentPersisterHandler
extends AbstractPersisterHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(CommentPersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final ProjectImportResults projectImportResults;
    private final BackupSystemInformation backupSystemInformation;
    private CommentParser commentParser;
    private CommentTransformer commentTransformer;

    public CommentPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.projectImportResults = projectImportResults;
        this.backupSystemInformation = backupSystemInformation;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        ExternalComment externalComment;
        if ("Action".equals(entityName) && (externalComment = this.getCommentParser().parse(attributes)) != null) {
            ExternalComment transformedExternalComment = this.getCommentTransformer().transform(this.projectImportMapper, externalComment);
            if (transformedExternalComment.getIssueId() != null) {
                this.execute(() -> {
                    Long commentId = this.projectImportPersister.createEntity(this.getCommentParser().getEntityRepresentation(transformedExternalComment));
                    if (externalComment.getId() != null) {
                        this.projectImportMapper.getCommentMapper().mapValue(String.valueOf(externalComment.getId()), String.valueOf(commentId));
                    }
                    if (commentId == null) {
                        String issueKey = this.backupSystemInformation.getIssueKeyForId(externalComment.getIssueId());
                        this.projectImportResults.addError(this.projectImportResults.getI18n().getText("admin.errors.project.import.comment.error", externalComment.getId(), issueKey));
                    }
                });
            } else {
                String issueKey = this.backupSystemInformation.getIssueKeyForId(externalComment.getIssueId());
                log.warn("Not saving comment '" + externalComment.getId() + "' it appears that the issue '" + issueKey + "' was not created as part of the import.");
            }
        }
    }

    CommentParser getCommentParser() {
        if (this.commentParser == null) {
            this.commentParser = new CommentParserImpl();
        }
        return this.commentParser;
    }

    CommentTransformer getCommentTransformer() {
        if (this.commentTransformer == null) {
            this.commentTransformer = new CommentTransformerImpl();
        }
        return this.commentTransformer;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }
}

