/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.IssueTypeMapper;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IssueTypeMapperHandler
implements ImportOfBizEntityHandler {
    public static final String ISSUETYPE_ENTITY_NAME = "IssueType";
    private final IssueTypeMapper issueTypeMapper;
    private static final String JIRA_SUBTASK = "jira_subtask";

    public IssueTypeMapperHandler(IssueTypeMapper issueTypeMapper) {
        this.issueTypeMapper = issueTypeMapper;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if (ISSUETYPE_ENTITY_NAME.equals(entityName)) {
            String id = attributes.get("id");
            String name = attributes.get("name");
            String style = attributes.get("style");
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new ParseException("Encountered an entity of type 'IssueType' with a missing ID.");
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new ParseException("The name of IssueType '" + id + "' is missing.");
            }
            this.issueTypeMapper.registerOldValue(id, name, JIRA_SUBTASK.equals(style));
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueTypeMapperHandler that = (IssueTypeMapperHandler)o;
        return !(this.issueTypeMapper != null ? !this.issueTypeMapper.equals((Object)that.issueTypeMapper) : that.issueTypeMapper != null);
    }

    public int hashCode() {
        return this.issueTypeMapper != null ? this.issueTypeMapper.hashCode() : 0;
    }
}

