/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.DelayCloseSearcher;
import com.atlassian.jira.index.DelegateSearcher;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.Ticker;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnmanagedIndexSearcher
extends DelegateSearcher
implements Closeable {
    public static final String INDEX_SEARCH_KEY = "search.index";
    private static final Logger log = LoggerFactory.getLogger(UnmanagedIndexSearcher.class);
    private final AtomicBoolean closedOnce;
    private final DelayCloseSearcher closeableSearcher;

    public UnmanagedIndexSearcher(DelayCloseSearcher searcher) {
        super((IndexSearcher)searcher);
        this.closeableSearcher = searcher;
        this.closedOnce = new AtomicBoolean(false);
    }

    DelayCloseSearcher internal() {
        return this.closeableSearcher;
    }

    @Override
    public void close() {
        if (this.closedOnce.compareAndSet(false, true)) {
            this.closeableSearcher.close();
        } else {
            log.warn("Trying to close an {} index searcher twice.", (Object)UnmanagedIndexSearcher.class.getSimpleName(), (Object)new Exception());
        }
    }

    public boolean isClosed() {
        return this.closedOnce.get();
    }

    public void search(Query query, Collector results) throws IOException {
        try (Ticker ignored = this.getMetricTimer(query);){
            super.search(query, results);
        }
    }

    public TopFieldDocs search(Query query, int n, Sort sort) throws IOException {
        try (Ticker ignored = this.getMetricTimer(query);){
            TopFieldDocs topFieldDocs = super.search(query, n, sort);
            return topFieldDocs;
        }
    }

    public TopDocs search(Query query, int n) throws IOException {
        try (Ticker ignored = this.getMetricTimer(query);){
            TopDocs topDocs = super.search(query, n);
            return topDocs;
        }
    }

    public TopFieldDocs search(Query query, int n, Sort sort, boolean doDocScores, boolean doMaxScore) throws IOException {
        try (Ticker ignored = this.getMetricTimer(query);){
            TopFieldDocs topFieldDocs = super.search(query, n, sort, doDocScores, doMaxScore);
            return topFieldDocs;
        }
    }

    public <C extends Collector, T> T search(Query query, CollectorManager<C, T> collectorManager) throws IOException {
        try (Ticker ignored = this.getMetricTimer(query);){
            Object object = super.search(query, collectorManager);
            return (T)object;
        }
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, int numHits) throws IOException {
        try (Ticker ignored = this.getMetricTimer(query);){
            TopDocs topDocs = super.searchAfter(after, query, numHits);
            return topDocs;
        }
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, int n, Sort sort) throws IOException {
        try (Ticker ignored = this.getMetricTimer(query);){
            TopDocs topDocs = super.searchAfter(after, query, n, sort);
            return topDocs;
        }
    }

    public TopFieldDocs searchAfter(ScoreDoc after, Query query, int numHits, Sort sort, boolean doDocScores, boolean doMaxScore) throws IOException {
        try (Ticker ignored = this.getMetricTimer(query);){
            TopFieldDocs topFieldDocs = super.searchAfter(after, query, numHits, sort, doDocScores, doMaxScore);
            return topFieldDocs;
        }
    }

    private Ticker getMetricTimer(Query query) {
        return Metrics.metric((String)INDEX_SEARCH_KEY).optionalTag("query", (String)Optional.of(query).map(Query::toString).orElse(null)).withInvokerPluginKey().withAnalytics().startTimer();
    }
}

