/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.index.ha.IndexSnapshotOperator;
import com.atlassian.jira.index.ha.IndexUtils;
import com.atlassian.jira.index.ha.TemporaryFilesProvider;
import com.atlassian.jira.issue.index.IndexException;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.DelegatorInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexSnapshotOperator
implements IndexSnapshotOperator {
    public static final String DEFAULT_DATE_FORMAT = "yyMMdd-HHmmss";
    private static final String INDEX_BACKUP_SEQUENCE = "IndexBackupSequence";
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexSnapshotOperator.class);
    private final FileStores fileStores;
    private final IndexUtils indexUtils;
    private final DelegatorInterface delegatorInterface;

    public DefaultIndexSnapshotOperator(FileStores fileStores, IndexUtils indexUtils, DelegatorInterface delegatorInterface) {
        this.fileStores = fileStores;
        this.indexUtils = indexUtils;
        this.delegatorInterface = delegatorInterface;
    }

    @Override
    public String performIndexSnapshotBackupAndCleanup() {
        return this.performIndexSnapshotBackupAndCleanup(null, null);
    }

    @Override
    public String performIndexSnapshotBackupAndCleanup(TemporaryFilesProvider temporaryFilesProvider, String notifyNode) {
        String destinationPath = this.getSnapshotDirPath().getAbsolutePath();
        String id = this.delegatorInterface.getNextSeqId(INDEX_BACKUP_SEQUENCE) + "_" + new SimpleDateFormat(DEFAULT_DATE_FORMAT).format(new Date());
        try {
            return this.indexUtils.performBackupOperations(destinationPath, id, temporaryFilesProvider, notifyNode);
        }
        catch (IndexException | ExecutionException | TimeoutException ex) {
            log.error("Index backup failed. {}", (Object)ex.getMessage());
            return null;
        }
        catch (InterruptedException ex) {
            log.error("Interrupted while preparing index backup", (Throwable)ex);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public List<Path> listIndexSnapshots() {
        File snapshotsDirectory = this.getSnapshotDirPath();
        String[] snapshots = snapshotsDirectory.list((FilenameFilter)IndexUtils.INDEX_SNAPSHOT_FILTER);
        if (snapshots == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(snapshots).map(filename -> Paths.get(snapshotsDirectory.getAbsolutePath(), filename)).collect(Collectors.toList());
    }

    private File getSnapshotDirPath() {
        return this.fileStores.getIndexSnapshotsPath().asJavaFile();
    }
}

