/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.index.ha.IndexRecoveryResult;
import com.atlassian.jira.index.ha.IndexRepairStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import java.util.stream.Stream;

class MutableIndexRepairStats
implements IndexRepairStats {
    private MutableLongStats processedDeindexOperations = new MutableLongStats(new long[0]);
    private MutableLongStats processedReindexOperations = new MutableLongStats(new long[0]);
    private MutableLongStats durationIsLongerThanRetentionPeriod = new MutableLongStats(new long[0]);
    private MutableLongStats errors = new MutableLongStats(new long[0]);
    private MutableLongStats indexRecoveryMillis = new MutableLongStats(new long[0]);

    MutableIndexRepairStats() {
    }

    @Override
    public void onIndexRecovery(IndexRecoveryResult indexRecoveryResult, long indexRecoveryMillis) {
        this.processedDeindexOperations.accept(indexRecoveryResult.getProcessedDeindexOperations());
        this.processedReindexOperations.accept(indexRecoveryResult.getProcessedReindexOperations());
        this.durationIsLongerThanRetentionPeriod.accept(indexRecoveryResult.isDurationIsLongerThanRetentionPeriod() ? 1L : 0L);
        this.indexRecoveryMillis.accept(indexRecoveryMillis);
    }

    @Override
    public void onError() {
        this.errors.accept(1L);
    }

    void reset() {
        Stream.of(this.processedDeindexOperations, this.processedReindexOperations, this.durationIsLongerThanRetentionPeriod, this.indexRecoveryMillis, this.errors).forEach(MutableLongStats::reset);
    }

    Result get() {
        return new Result();
    }

    class Result {
        private final LongStats processedDeindexOperations;
        private final LongStats processedReindexOperations;
        private final LongStats durationIsLongerThanRetentionPeriod;
        private final LongStats indexRecoveryMillis;
        private final LongStats errors;

        Result() {
            this.processedDeindexOperations = MutableIndexRepairStats.this.processedDeindexOperations.get();
            this.processedReindexOperations = MutableIndexRepairStats.this.processedReindexOperations.get();
            this.durationIsLongerThanRetentionPeriod = MutableIndexRepairStats.this.durationIsLongerThanRetentionPeriod.get();
            this.indexRecoveryMillis = MutableIndexRepairStats.this.indexRecoveryMillis.get();
            this.errors = MutableIndexRepairStats.this.errors.get();
        }
    }
}

