/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.index.ha.events.ReplicationStatisticsAnalyticsEvent;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationStats {
    private static final String PREFIX = "[JIRA-STATS] [replication-stats] ";
    private static final Logger log = LoggerFactory.getLogger(ReplicationStats.class);
    private final ImmutableMap<Index, MutableAffectedIndexStats> totalStats;
    private final ImmutableMap<Index, MutableAffectedIndexStats> snapshotStats;
    private final long systemStartTimestampMillis = System.currentTimeMillis();
    private long lastPrintTime = System.currentTimeMillis();
    private final ReentrantLock printLock = new ReentrantLock();
    private final EventPublisher eventPublisher;
    private final long loggingMinSeconds;

    ReplicationStats(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        ImmutableMap.Builder totalStatsMapBuilder = ImmutableMap.builder();
        for (Index index : Index.values()) {
            totalStatsMapBuilder.put((Object)index, (Object)new MutableAffectedIndexStats());
        }
        this.totalStats = totalStatsMapBuilder.build();
        ImmutableMap.Builder snapshotStatsMapBuilder = ImmutableMap.builder();
        for (Index index : Index.values()) {
            snapshotStatsMapBuilder.put((Object)index, (Object)new MutableAffectedIndexStats());
        }
        this.snapshotStats = snapshotStatsMapBuilder.build();
        this.loggingMinSeconds = JiraStats.statsLoggingInterval(TimeUnit.SECONDS);
        log.info("[JIRA-STATS] [replication-stats] stats will be running every: {} sec", (Object)this.loggingMinSeconds);
    }

    long getLoggingMinSeconds() {
        return this.loggingMinSeconds;
    }

    void addDataPoint(Index affectedIndex, long replicationLatencyMillis, long localProcessingTimeMillis) {
        Preconditions.checkNotNull((Object)((Object)affectedIndex));
        long currentMillis = System.currentTimeMillis();
        ((MutableAffectedIndexStats)this.totalStats.get((Object)affectedIndex)).addDataPoint(replicationLatencyMillis, localProcessingTimeMillis);
        ((MutableAffectedIndexStats)this.snapshotStats.get((Object)affectedIndex)).addDataPoint(replicationLatencyMillis, localProcessingTimeMillis);
        this.logStats(currentMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStats(long currentMillis) {
        long loggingMinSeconds = this.getLoggingMinSeconds();
        if (this.enoughTimeElapsedSinceLastLogging(currentMillis, loggingMinSeconds)) {
            try {
                this.printLock.lock();
                if (this.enoughTimeElapsedSinceLastLogging(currentMillis, loggingMinSeconds)) {
                    Gson gson = new Gson();
                    String totalStatsJson = gson.toJson(this.totalStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MutableAffectedIndexStats)e.getValue()).get())));
                    log.info("{}Total replication latency statistics. Now: {}, systemStartTimestamp: {}, elapsedDuration:{}, stats: {}", new Object[]{PREFIX, currentMillis, this.systemStartTimestampMillis, Duration.ofMillis(currentMillis - this.systemStartTimestampMillis), totalStatsJson});
                    this.publishAnalyticsEvent((Map<Index, MutableAffectedIndexStats>)this.totalStats, ReplicationStatisticsAnalyticsEvent.StatisticsType.TOTAL, this.systemStartTimestampMillis, currentMillis);
                    String snapshotStatsJson = gson.toJson(this.snapshotStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MutableAffectedIndexStats)e.getValue()).get())));
                    log.info("{}Snapshot replication latency statistics. Now: {}, startTimestamp: {}, elapsedDuration:{}, stats: {}", new Object[]{PREFIX, currentMillis, this.lastPrintTime, Duration.ofMillis(currentMillis - this.lastPrintTime), snapshotStatsJson});
                    this.publishAnalyticsEvent((Map<Index, MutableAffectedIndexStats>)this.snapshotStats, ReplicationStatisticsAnalyticsEvent.StatisticsType.SNAPSHOT, this.lastPrintTime, currentMillis);
                    this.lastPrintTime = currentMillis;
                    this.snapshotStats.values().forEach(MutableAffectedIndexStats::reset);
                }
            }
            finally {
                this.printLock.unlock();
            }
        }
    }

    private void publishAnalyticsEvent(Map<Index, MutableAffectedIndexStats> stats, ReplicationStatisticsAnalyticsEvent.StatisticsType type, long measurementStart, long measurementEnd) {
        stats.entrySet().stream().map(e -> this.mapToEvent(type, measurementStart, measurementEnd, (Map.Entry<Index, MutableAffectedIndexStats>)e)).forEach(arg_0 -> ((EventPublisher)this.eventPublisher).publish(arg_0));
    }

    private ReplicationStatisticsAnalyticsEvent mapToEvent(ReplicationStatisticsAnalyticsEvent.StatisticsType type, long measurementStart, long measurementEnd, Map.Entry<Index, MutableAffectedIndexStats> e) {
        return new ReplicationStatisticsAnalyticsEvent(type, e.getKey(), measurementStart, measurementEnd, e.getValue().getReplicationLatencyStats(), e.getValue().getLocalProcessingTimeStats());
    }

    private boolean enoughTimeElapsedSinceLastLogging(long currentMillis, long loggingMinSeconds) {
        return TimeUnit.MILLISECONDS.toSeconds(currentMillis - this.lastPrintTime) >= loggingMinSeconds;
    }

    public static class MutableAffectedIndexStats {
        private final MutableLongStats replicationLatencyStats = new MutableLongStats(1000L, 5000L, 10000L, 30000L, 60000L, 600000L);
        private final MutableLongStats localProcessingTimeStats = new MutableLongStats(1000L, 5000L, 10000L, 30000L, 60000L, 600000L);

        void addDataPoint(long replicationLatencyMillis, long localProcessingTimeMillis) {
            this.replicationLatencyStats.accept(replicationLatencyMillis);
            this.localProcessingTimeStats.accept(localProcessingTimeMillis);
        }

        void reset() {
            this.replicationLatencyStats.reset();
            this.localProcessingTimeStats.reset();
        }

        public LongStats getReplicationLatencyStats() {
            return this.replicationLatencyStats.get();
        }

        public LongStats getLocalProcessingTimeStats() {
            return this.localProcessingTimeStats.get();
        }

        AffectedIndexStats get() {
            return new AffectedIndexStats();
        }

        class AffectedIndexStats {
            final LongStats replicationLatencyStats;
            final LongStats localProcessingTimeStats;

            AffectedIndexStats() {
                this.replicationLatencyStats = MutableAffectedIndexStats.this.replicationLatencyStats.get();
                this.localProcessingTimeStats = MutableAffectedIndexStats.this.localProcessingTimeStats.get();
            }
        }
    }

    public static enum Index {
        ISSUE,
        COMMENT,
        WORKLOG,
        SHAREDENTITY;


        static Index from(AffectedIndex affectedIndex) {
            switch (affectedIndex) {
                case ISSUE: {
                    return ISSUE;
                }
                case COMMENT: {
                    return COMMENT;
                }
                case WORKLOG: {
                    return WORKLOG;
                }
                case SHAREDENTITY: {
                    return SHAREDENTITY;
                }
            }
            throw new IllegalStateException("Unsupported operation: " + affectedIndex);
        }
    }
}

