/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha.backup;

import com.atlassian.jira.index.ha.backup.BackupBuilder;
import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.compression.ArchiveCompressor;
import com.atlassian.jira.util.compression.ArchiveUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableBackupBuilder
implements Closeable,
BackupBuilder {
    private static final Logger log = LoggerFactory.getLogger(CloseableBackupBuilder.class);
    private final Consumer<File> filesObserver;
    private final ArchiveCompressor archiveCompressor;

    private CloseableBackupBuilder(@Nonnull File snapshot, @Nonnull ArchiveUtils.Type archiveType, @Nullable Consumer<File> filesObserver) {
        this.filesObserver = filesObserver;
        this.archiveCompressor = ArchiveUtils.createArchiveCompressor(snapshot, archiveType);
    }

    public static CloseableBackupBuilder open(@Nonnull File snapshot, @Nonnull ArchiveUtils.Type archiveType, @Nullable Consumer<File> filesObserver) {
        return new CloseableBackupBuilder(snapshot, archiveType, filesObserver);
    }

    @Override
    public void addToBackup(Collection<File> files, File rootDirectory) {
        try {
            log.debug("Adding to backup {} files from directory {}", (Object)files.size(), (Object)rootDirectory.getPath());
            for (File file : files) {
                if (this.filesObserver != null) {
                    try {
                        this.filesObserver.accept(file);
                    }
                    catch (Exception e) {
                        log.error("Error when notifying about file: {} added to backup, error: {}", new Object[]{file.getPath(), e.getMessage(), e});
                    }
                }
                this.archiveCompressor.addFile(file, rootDirectory);
            }
            log.debug("Done adding to backup {} files from directory {}", (Object)files.size(), (Object)rootDirectory.getPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.archiveCompressor.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

