/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha.events;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.index.ha.ReplicationStats;
import com.atlassian.jira.util.stats.LongStats;

@EventName(value="jira.index.replication.statistics")
public class ReplicationStatisticsAnalyticsEvent {
    private final StatisticsType type;
    private final ReplicationStats.Index index;
    final long measurementStart;
    final long measurementEnd;
    final long replicationLatencyCount;
    final long replicationLatencyMin;
    final long replicationLatencyMax;
    final long replicationLatencySum;
    final long localProcessingTimeCount;
    final long localProcessingTimeMin;
    final long localProcessingTimeMax;
    final long localProcessingTimeSum;

    public ReplicationStatisticsAnalyticsEvent(StatisticsType type, ReplicationStats.Index index, long measurementStart, long measurementEnd, LongStats replicationLatencyStats, LongStats localProcessingTimeStats) {
        this.type = type;
        this.index = index;
        this.measurementStart = measurementStart;
        this.measurementEnd = measurementEnd;
        this.replicationLatencyCount = replicationLatencyStats.count();
        this.replicationLatencyMin = replicationLatencyStats.min();
        this.replicationLatencyMax = replicationLatencyStats.max();
        this.replicationLatencySum = replicationLatencyStats.sum();
        this.localProcessingTimeCount = localProcessingTimeStats.count();
        this.localProcessingTimeMin = localProcessingTimeStats.min();
        this.localProcessingTimeMax = localProcessingTimeStats.max();
        this.localProcessingTimeSum = localProcessingTimeStats.sum();
    }

    public StatisticsType getType() {
        return this.type;
    }

    public ReplicationStats.Index getIndex() {
        return this.index;
    }

    public long getMeasurementStart() {
        return this.measurementStart;
    }

    public long getMeasurementEnd() {
        return this.measurementEnd;
    }

    public long getReplicationLatencyCount() {
        return this.replicationLatencyCount;
    }

    public long getReplicationLatencyMin() {
        return this.replicationLatencyMin;
    }

    public long getReplicationLatencyMax() {
        return this.replicationLatencyMax;
    }

    public long getReplicationLatencySum() {
        return this.replicationLatencySum;
    }

    public long getLocalProcessingTimeCount() {
        return this.localProcessingTimeCount;
    }

    public long getLocalProcessingTimeMin() {
        return this.localProcessingTimeMin;
    }

    public long getLocalProcessingTimeMax() {
        return this.localProcessingTimeMax;
    }

    public long getLocalProcessingTimeSum() {
        return this.localProcessingTimeSum;
    }

    public static enum StatisticsType {
        TOTAL,
        SNAPSHOT;

    }
}

