/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.external;

import com.atlassian.instrumentation.ExternalGauge;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationLoader;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.ServletContextProvider;
import com.google.common.collect.ImmutableList;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URI;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.ofbiz.core.entity.config.JndiDatasourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabaseExternalGauges {
    private static final Logger log = LoggerFactory.getLogger(DatabaseExternalGauges.class);
    private static final String JIRA_MBEAN_NAME = "com.atlassian.jira:name=BasicDataSource";
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final DatabaseConfigurationLoader databaseConfigurationLoader;

    DatabaseExternalGauges(VelocityRequestContextFactory velocityRequestContextFactory, DatabaseConfigurationLoader databaseConfigurationLoader) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.databaseConfigurationLoader = databaseConfigurationLoader;
    }

    DatabaseExternalGauges installInstruments() {
        DbcpInstruments instruments = this.createInstruments();
        log.info("Installing DBCP monitoring instruments: {}", (Object)instruments);
        instruments.install();
        return this;
    }

    private DbcpInstruments createInstruments() {
        DbcpInstruments instruments = new JiraDbcpInstruments(JIRA_MBEAN_NAME);
        try {
            JndiDatasourceInfo jndiInfo;
            DatabaseConfig dbConfig = this.databaseConfigurationLoader.loadDatabaseConfiguration();
            JndiDatasourceInfo jndiDatasourceInfo = dbConfig != null ? (dbConfig.getDatasourceInfo() != null ? dbConfig.getDatasourceInfo().getJndiDatasource() : null) : (jndiInfo = null);
            if (jndiInfo != null) {
                instruments = new TomcatDbcpInstruments(jndiInfo);
            }
        }
        catch (RuntimeException e) {
            log.debug("Couldn't read database configuration at this point. Does dbconfig.xml exist?", (Throwable)e);
        }
        return instruments;
    }

    String getContextPath() {
        String contextPath = this.determineContextPath();
        return "".equals(contextPath) ? "/" : contextPath;
    }

    private String determineContextPath() {
        ServletContext servletContext = ServletContextProvider.getServletContext();
        try {
            Method getContextPath = servletContext.getClass().getMethod("getContextPath", new Class[0]);
            return String.valueOf(getContextPath.invoke((Object)servletContext, (Object[])null));
        }
        catch (Exception e) {
            VelocityRequestContext ctx = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
            try {
                return ctx != null ? URI.create(ctx.getBaseUrl()).getPath() : "/";
            }
            catch (Exception e1) {
                return "/";
            }
        }
    }

    static class DbcpGauge
    implements ExternalValue {
        private final String objectName;
        private final String attribute;

        public DbcpGauge(String objectName, String attribute) {
            this.objectName = objectName;
            this.attribute = attribute;
        }

        public long getValue() {
            try {
                MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                return ((Integer)platformMBeanServer.getAttribute(new ObjectName(this.objectName), this.attribute)).intValue();
            }
            catch (Exception e) {
                return -1L;
            }
        }
    }

    class TomcatDbcpInstruments
    extends DbcpInstruments {
        TomcatDbcpInstruments(JndiDatasourceInfo jndiInfo) {
            super(String.format("Catalina:type=DataSource,path=%s,host=%s,class=javax.sql.DataSource,name=\"%s\"", DatabaseExternalGauges.this.getContextPath(), "localhost", StringUtils.replace((String)jndiInfo.getJndiName(), (String)"java:comp/env/", (String)"")));
        }
    }

    static class JiraDbcpInstruments
    extends DbcpInstruments {
        JiraDbcpInstruments(String objectName) {
            super(objectName);
        }

        @Override
        protected String attributeName(InstrumentationName name) {
            return StringUtils.capitalize((String)super.attributeName(name));
        }
    }

    static abstract class DbcpInstruments {
        private final ImmutableList<InstrumentationName> instruments = ImmutableList.of((Object)((Object)InstrumentationName.DBCP_MAX), (Object)((Object)InstrumentationName.DBCP_ACTIVE), (Object)((Object)InstrumentationName.DBCP_IDLE));
        private final String objectName;

        protected DbcpInstruments(String objectName) {
            this.objectName = objectName;
        }

        public final DbcpInstruments install() {
            for (InstrumentationName name : this.instruments) {
                this.install(name);
            }
            return this;
        }

        public final String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        protected String attributeName(InstrumentationName name) {
            return StringUtils.replace((String)name.getInstrumentName(), (String)"dbcp.", (String)"");
        }

        private void install(InstrumentationName instrument) {
            Instrumentation.putInstrument((Instrument)new ExternalGauge(instrument.getInstrumentName(), (ExternalValue)new DbcpGauge(this.objectName, this.attributeName(instrument))));
        }
    }
}

