/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd;

import com.atlassian.jira.ipd.InProductDiagnosticMeasureType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum IpdMetricName {
    DB_CONNECTION_LATENCY("db.connection.latency", EnumSet.of(InProductDiagnosticMeasureType.STATS, InProductDiagnosticMeasureType.LAST_VALUE)),
    DB_CONNECTION_STATE("db.connection.state", EnumSet.of(InProductDiagnosticMeasureType.LAST_VALUE)),
    DB_CONNECTION_FAILURES("db.connection.failures", EnumSet.of(InProductDiagnosticMeasureType.COUNTER)),
    DB_CONNECTION_POOL_IDLE("db.connection.pool.numIdle", EnumSet.of(InProductDiagnosticMeasureType.STATS, InProductDiagnosticMeasureType.LAST_VALUE)),
    DB_CONNECTION_POOL_ACTIVE("db.connection.pool.numActive", EnumSet.of(InProductDiagnosticMeasureType.STATS, InProductDiagnosticMeasureType.LAST_VALUE));

    private final String baseName;
    private String statisticsName = null;
    private String lastValueName = null;
    private String counterName = null;
    private final Set<InProductDiagnosticMeasureType> measureTypes;
    public static final List<String> POSSIBLE_IPD_METRIC_NAMES;

    private IpdMetricName(String baseName, EnumSet<InProductDiagnosticMeasureType> measureTypes) {
        this.baseName = baseName;
        this.measureTypes = Sets.immutableEnumSet(measureTypes);
        if (measureTypes.contains((Object)InProductDiagnosticMeasureType.STATS)) {
            this.statisticsName = baseName + ".statistics";
        }
        if (measureTypes.contains((Object)InProductDiagnosticMeasureType.LAST_VALUE)) {
            this.lastValueName = baseName + ".value";
        }
        if (measureTypes.contains((Object)InProductDiagnosticMeasureType.COUNTER)) {
            this.counterName = baseName + ".counter";
        }
    }

    @Nonnull
    public String getBaseName() {
        return this.baseName;
    }

    @Nullable
    public String getStatisticsName() {
        return this.statisticsName;
    }

    @Nullable
    public String getLastValueName() {
        return this.lastValueName;
    }

    @Nullable
    public String getCounterName() {
        return this.counterName;
    }

    @Nonnull
    public Set<InProductDiagnosticMeasureType> getMeasureTypes() {
        return this.measureTypes;
    }

    static {
        POSSIBLE_IPD_METRIC_NAMES = (List)Stream.of(IpdMetricName.values()).flatMap(metric -> Stream.of(metric.getLastValueName(), metric.getStatisticsName(), metric.getCounterName())).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }
}

