/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.db;

import com.atlassian.jira.database.DatabaseConnectionStateService;
import com.atlassian.jira.ipd.InProductDiagnosticJob;
import com.atlassian.jira.ipd.InProductDiagnosticJobRunner;
import com.atlassian.jira.ipd.InProductDiagnosticMeasureType;
import com.atlassian.jira.ipd.InProductDiagnosticMeasurement;
import com.atlassian.jira.ipd.IpdMetricName;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;

public class DatabaseConnectionFailuresInProductDiagnosticJob
implements InProductDiagnosticJob {
    private static final long DB_DISCONNECTED_INCREMENT_VALUE = 1L;
    private static final long DB_CONNECTED_INCREMENT_VALUE = 0L;
    private final DatabaseConnectionStateService databaseConnectionStateService;

    public DatabaseConnectionFailuresInProductDiagnosticJob(DatabaseConnectionStateService databaseConnectionStateService, InProductDiagnosticJobRunner inProductDiagnosticScheduler) {
        this.databaseConnectionStateService = databaseConnectionStateService;
        inProductDiagnosticScheduler.register(this);
    }

    @Override
    public List<InProductDiagnosticMeasurement> measure() {
        DatabaseConnectionStateService.DatabaseConnectionState state = this.databaseConnectionStateService.getState();
        return ImmutableList.of((Object)new InProductDiagnosticMeasurement(EnumSet.of(InProductDiagnosticMeasureType.COUNTER), IpdMetricName.DB_CONNECTION_FAILURES, state == DatabaseConnectionStateService.DatabaseConnectionState.DISCONNECTED ? 1L : 0L));
    }
}

