/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.db;

import com.atlassian.jira.database.DatabaseConnectionStateService;
import com.atlassian.jira.ipd.InProductDiagnosticJob;
import com.atlassian.jira.ipd.InProductDiagnosticJobRunner;
import com.atlassian.jira.ipd.InProductDiagnosticMeasureType;
import com.atlassian.jira.ipd.InProductDiagnosticMeasurement;
import com.atlassian.jira.ipd.IpdMetricName;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

public class DatabaseLatencyInProductDiagnosticJob
implements InProductDiagnosticJob {
    private final DatabaseConnectionStateService databaseConnectionStateService;

    public DatabaseLatencyInProductDiagnosticJob(DatabaseConnectionStateService databaseConnectionStateService, InProductDiagnosticJobRunner inProductDiagnosticScheduler) {
        this.databaseConnectionStateService = databaseConnectionStateService;
        inProductDiagnosticScheduler.register(this);
    }

    @Override
    public List<InProductDiagnosticMeasurement> measure() {
        Optional<Duration> latency = this.databaseConnectionStateService.getLatency();
        EnumSet<InProductDiagnosticMeasureType> measureTypes = EnumSet.of(InProductDiagnosticMeasureType.LAST_VALUE);
        if (latency.isPresent()) {
            measureTypes.add(InProductDiagnosticMeasureType.STATS);
        }
        long value = latency.map(Duration::toMillis).orElse(-1L);
        return ImmutableList.of((Object)new InProductDiagnosticMeasurement(measureTypes, IpdMetricName.DB_CONNECTION_LATENCY, value));
    }
}

