/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class IssueUtils {
    public static final String AUTOMATIC_ASSIGNEE = "-1";
    public static final String SEPERATOR_ASSIGNEE = "-2";
    protected static final Logger log = Logger.getLogger(IssueUtils.class);

    public static void filterIssues(Collection<Issue> issues, Predicate<Issue> filter) {
        Iterator<Issue> iterator = issues.iterator();
        while (iterator.hasNext()) {
            Issue issue = iterator.next();
            if (!filter.evaluate((Object)issue)) continue;
            iterator.remove();
        }
    }

    @Deprecated
    public static GenericValue setPriority(GenericValue issue, ApplicationUser remoteUser, String priority) throws GenericEntityException {
        GenericValue originalIssue = ComponentAccessor.getIssueManager().getIssue(issue.getLong("id"));
        issue.setString("priority", priority);
        issue.set("updated", (Object)UtilDateTime.nowTimestamp());
        GenericValue changeGroup = ChangeLogUtils.createChangeGroup(remoteUser, originalIssue, issue, Collections.emptyList(), true);
        ComponentAccessor.getOfBizDelegator().storeAll(Arrays.asList(issue));
        return changeGroup;
    }

    public static boolean hasTimeTracking(Issue issue) {
        if (issue == null) {
            return false;
        }
        Long orig = issue.getOriginalEstimate();
        Long est = issue.getEstimate();
        Long spent = issue.getTimeSpent();
        return IssueUtils.isNonZeroNumber(orig) || IssueUtils.isNonZeroNumber(est) || IssueUtils.isNonZeroNumber(spent);
    }

    private static boolean isNonZeroNumber(Long aLong) {
        return aLong != null && aLong != 0L;
    }
}

