/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringEscapeUtils;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LocaleParser;
import com.atlassian.jira.web.bean.I18nBean;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Locale;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIssueConstant
implements IssueConstant {
    private static final Logger log = LoggerFactory.getLogger(TextIssueConstant.class);
    private static final Long SEQUENCE = new Long(0L);
    private String nameKey;
    private String descriptionKey;
    private String iconUrl;
    private final JiraAuthenticationContext authenticationContext;

    public TextIssueConstant(String nameKey, String descriptionKey, String iconUrl, JiraAuthenticationContext authenticationContext) {
        this.nameKey = nameKey;
        this.descriptionKey = descriptionKey;
        this.iconUrl = iconUrl;
        this.authenticationContext = authenticationContext;
    }

    public GenericValue getGenericValue() {
        this.handleException();
        return null;
    }

    public String getId() {
        return "-1";
    }

    public String getName() {
        return this.getI18n().getText(this.nameKey);
    }

    public void setName(String name) {
        this.handleException();
    }

    public String getDescription() {
        return this.getI18n().getText(this.descriptionKey);
    }

    public void setDescription(String description) {
        this.handleException();
    }

    public Long getSequence() {
        return SEQUENCE;
    }

    public void setSequence(Long sequence) {
        this.handleException();
    }

    public String getCompleteIconUrl() {
        return this.getIconUrl();
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getIconUrlHtml() {
        return StringEscapeUtils.escapeHtml((String)this.getIconUrl());
    }

    public void setIconUrl(String iconURL) {
        this.handleException();
    }

    public String getNameTranslation() {
        return this.getI18n().getText(this.nameKey);
    }

    public String getDescTranslation() {
        return this.getI18n().getText(this.descriptionKey);
    }

    public String getNameTranslation(String locale) {
        return new I18nBean(LocaleParser.parseLocale((String)locale)).getText(this.nameKey);
    }

    public String getDescTranslation(String locale) {
        return new I18nBean(LocaleParser.parseLocale((String)locale)).getText(this.descriptionKey);
    }

    public String getNameTranslation(I18nHelper i18n) {
        return new I18nBean(i18n.getLocale()).getText(this.nameKey);
    }

    public String getDescTranslation(I18nHelper i18n) {
        return new I18nBean(i18n.getLocale()).getText(this.descriptionKey);
    }

    public void setTranslation(String translatedName, String translatedDesc, String issueConstantPrefix, Locale locale) {
        this.handleException();
    }

    public void deleteTranslation(String issueConstantPrefix, Locale locale) {
        this.handleException();
    }

    public PropertySet getPropertySet() {
        this.handleException();
        return null;
    }

    public int compareTo(Object o) {
        return 0;
    }

    private I18nHelper getI18n() {
        return this.authenticationContext.getI18nHelper();
    }

    private void handleException() {
        log.warn("Unable to call method. Method not implemented");
        throw new IllegalArgumentException("Unable to call method. Method not implemented");
    }
}

