/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.zip;

import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.BulkAttachmentOperations;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.io.InputStreamConsumer;
import io.atlassian.fugue.Unit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentZipFileCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentZipFileCreator.class);
    private final BulkAttachmentOperations bulkAttachmentOperations;
    private final AttachmentManager attachmentManager;

    public AttachmentZipFileCreator(BulkAttachmentOperations bulkAttachmentOperations, AttachmentManager attachmentManager) {
        this.bulkAttachmentOperations = bulkAttachmentOperations;
        this.attachmentManager = attachmentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File toZipFile(Issue issue) throws IOException {
        File zipFile = File.createTempFile(issue.getKey() + "-", ".zip");
        UniqueFileNameGenerator uniqueFileNameGenerator = new UniqueFileNameGenerator();
        ZipArchiveOutputStream out = null;
        try {
            out = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));
            this.copyAttachmentsToZipFile(issue, uniqueFileNameGenerator, out);
        }
        catch (Throwable throwable) {
            IOUtil.shutdownStream(out);
            throw throwable;
        }
        IOUtil.shutdownStream((OutputStream)out);
        return zipFile;
    }

    private void copyAttachmentsToZipFile(Issue issue, UniqueFileNameGenerator uniqueFileNameGenerator, ZipArchiveOutputStream out) {
        EnclosedIterable<Attachment> attachmentsOfIssue = this.bulkAttachmentOperations.getAttachmentOfIssue(issue);
        attachmentsOfIssue.foreach(this.copyAttachmentToOutput(uniqueFileNameGenerator, out));
    }

    private Consumer<Attachment> copyAttachmentToOutput(final UniqueFileNameGenerator uniqueFileNameGenerator, final ZipArchiveOutputStream out) {
        return new Consumer<Attachment>(){

            public void consume(final @Nonnull Attachment attachment) {
                InputStreamConsumer<Unit> streamConsumer = new InputStreamConsumer<Unit>(){

                    public Unit withInputStream(InputStream inputStream) throws IOException {
                        String attachmentFileName = attachment.getFilename();
                        ZipArchiveEntry zipEntry = new ZipArchiveEntry(uniqueFileNameGenerator.getUniqueFileName(attachmentFileName));
                        out.putArchiveEntry((ArchiveEntry)zipEntry);
                        IOUtil.copy(inputStream, (OutputStream)out);
                        out.closeArchiveEntry();
                        return Unit.Unit();
                    }
                };
                try {
                    AttachmentZipFileCreator.this.attachmentManager.streamAttachmentContent(attachment, (InputStreamConsumer)streamConsumer);
                }
                catch (IOException e) {
                    LOGGER.info("Streaming operation failed for attachment with Id " + attachment.getId());
                }
            }
        };
    }

    static class UniqueFileNameGenerator {
        private static final Pattern pattern = Pattern.compile("\\.([0-9]+)$");
        private Set<String> fileNamesSet = new HashSet<String>();

        UniqueFileNameGenerator() {
        }

        public String getUniqueFileName(String fileName) {
            String safeFileName = fileName;
            while (this.fileNamesSet.contains(safeFileName)) {
                safeFileName = this.mungeFileName(safeFileName);
            }
            this.fileNamesSet.add(safeFileName);
            return safeFileName;
        }

        private String mungeFileName(String fileName) {
            Matcher m = pattern.matcher(fileName);
            if (m.find()) {
                String numberStr = m.group(m.groupCount());
                int number = Integer.parseInt(numberStr, 10) + 1;
                return m.replaceFirst("." + number);
            }
            return fileName + ".1";
        }
    }
}

