/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.comment.CommentDeletedEvent;
import com.atlassian.jira.event.commit.OnCommitEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.issue.JiraIssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEventBundle;
import com.atlassian.jira.event.issue.commit.OnCommitJiraIssueEventBuilder;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentEventPublisher;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class CommentEventPublisherImpl
implements CommentEventPublisher {
    private final IssueEventManager issueEventManager;
    private final EventPublisher eventPublisher;
    private final IssueEventBundleFactory issueEventBundleFactory;

    public CommentEventPublisherImpl(IssueEventManager issueEventManager, EventPublisher eventPublisher, IssueEventBundleFactory issueEventBundleFactory) {
        this.issueEventManager = issueEventManager;
        this.eventPublisher = eventPublisher;
        this.issueEventBundleFactory = issueEventBundleFactory;
    }

    @Override
    public void publishCommentUpdatedEvent(Comment comment, Map<String, Object> parameters) {
        IssueEventBundle issueCommentBundle = this.issueEventBundleFactory.createCommentEditedBundle(comment.getIssue(), comment.getUpdateAuthorApplicationUser(), comment, parameters);
        this.issueEventManager.dispatchEvent(issueCommentBundle);
        this.issueEventManager.dispatchRedundantEvent(EventType.ISSUE_COMMENT_EDITED_ID, comment.getIssue(), comment.getUpdateAuthorUser(), comment, null, null, parameters);
    }

    @Override
    public void publishCommentCreatedEvent(Comment comment, Map<String, Object> parameters) {
        IssueEventBundle issueCommentBundle = this.issueEventBundleFactory.createCommentAddedBundle(comment.getIssue(), comment.getUpdateAuthorApplicationUser(), comment, parameters);
        this.issueEventManager.dispatchEvent(issueCommentBundle);
        this.issueEventManager.dispatchRedundantEvent(EventType.ISSUE_COMMENTED_ID, comment.getIssue(), comment.getUpdateAuthorUser(), comment, null, null, parameters);
    }

    @Override
    public void publishCommentDeletedEvent(Comment comment) {
        CommentDeletedEvent commentDeletedEvent = new CommentDeletedEvent(comment);
        this.eventPublisher.publish((Object)commentDeletedEvent);
        ImmutableList onCommitBundleEvents = ImmutableList.of((Object)OnCommitJiraIssueEventBuilder.builder((JiraIssueEvent)commentDeletedEvent).setOnCommitEventDataReloadStatus(OnCommitEvent.OnCommitEventDataReloadStatus.NOT_RELOADED_ON_COMMIT).build());
        this.issueEventManager.dispatchIssueEventBundleOnCommit(() -> CommentEventPublisherImpl.lambda$publishCommentDeletedEvent$1((List)onCommitBundleEvents));
    }

    private static /* synthetic */ OnCommitIssueEventBundle lambda$publishCommentDeletedEvent$1(List onCommitBundleEvents) {
        return () -> onCommitBundleEvents;
    }
}

