/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.ActionDTOToCommentConverter;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.model.querydsl.ActionDTO;
import com.atlassian.jira.model.querydsl.QAction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.SplitStreamHelper;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.StatementOptions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StreamingCommentsRetriever {
    public static final int COMMENTS_FETCH_SIZE = 10000;
    private final QueryDslAccessor queryDslAccessor;
    private final CommentPermissionManager commentPermissionManager;
    private final DatabaseConfig databaseConfiguration;
    private final ActionDTOToCommentConverter converter;

    public StreamingCommentsRetriever(QueryDslAccessor queryDslAccessor, CommentPermissionManager commentPermissionManager, DatabaseConfigurationManager databaseConfigurationManager, ActionDTOToCommentConverter converter) {
        this.queryDslAccessor = queryDslAccessor;
        this.commentPermissionManager = commentPermissionManager;
        this.databaseConfiguration = databaseConfigurationManager.getDatabaseConfiguration();
        this.converter = converter;
    }

    public Stream<Comment> stream(@Nullable ApplicationUser user, @Nonnull Issue issue) {
        return SplitStreamHelper.streamWithSplitIterator(lastComment -> this.getCommentsForBatch(issue, (Optional<ActionDTO>)lastComment), 10000).map(dto -> this.converter.convert((ActionDTO)dto, issue)).filter(c -> this.commentPermissionManager.hasBrowsePermission(user, c));
    }

    @Nonnull
    private List<ActionDTO> getCommentsForBatch(Issue issue, Optional<ActionDTO> lastComment) {
        return this.queryDslAccessor.executeQuery(con -> {
            BooleanBuilder where = new BooleanBuilder();
            where.and((Predicate)QAction.ACTION.issue.eq((Object)issue.getId()));
            where.and((Predicate)QAction.ACTION.type.eq((Object)"comment"));
            lastComment.ifPresent(actionDTO -> where.and((Predicate)QAction.ACTION.created.gt((Comparable)actionDTO.getCreated()).or((Predicate)QAction.ACTION.created.eq((Object)actionDTO.getCreated()).and((Predicate)QAction.ACTION.id.gt((Number)actionDTO.getId())))));
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.newSqlQuery(con).select((Expression)QAction.ACTION).from((Expression)QAction.ACTION)).where((Predicate)where)).orderBy(new OrderSpecifier[]{QAction.ACTION.created.asc(), QAction.ACTION.id.asc()})).limit(10000L)).fetch();
        });
    }

    private SQLQuery<?> newSqlQuery(DbConnection con) {
        SQLQuery<?> query = con.newSqlQuery();
        int fetchSize = this.databaseConfiguration.isMySql() ? Integer.MIN_VALUE : 10000;
        query.setStatementOptions(StatementOptions.builder().setFetchSize(Integer.valueOf(fetchSize)).build());
        return query;
    }
}

