/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.config.item;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.UserFilterManager;
import com.atlassian.jira.user.UserFilterUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.util.Collection;
import java.util.Set;

public class UserFilterConfigItem
implements FieldConfigItemType {
    private final GroupManager groupManager;
    private final ProjectRoleManager projectRoleManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final UserFilterManager userFilterManager;

    public UserFilterConfigItem(GroupManager groupManager, ProjectRoleManager projectRoleManager, SoyTemplateRenderer soyTemplateRenderer, UserFilterManager userFilterManager) {
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.userFilterManager = userFilterManager;
    }

    public String getDisplayName() {
        return "User Filtering";
    }

    public String getDisplayNameKey() {
        return "admin.issuefields.customfields.config.userpickerfilter";
    }

    public String getViewHtml(FieldConfig fieldConfig, FieldLayoutItem fieldLayoutItem) {
        try {
            Collection allGroups = this.groupManager.getAllGroups();
            UserFilter filter = this.userFilterManager.getFilter(fieldConfig);
            return this.soyTemplateRenderer.render("jira.webresources:user-picker-filter-configuration-soy-templates", "JIRA.Templates.Admin.CustomFields.UserPickerFilter.showConfigSummary", MapBuilder.build((Object)"filter", (Object)filter, (Object)"groups", (Object)UserFilterUtils.sortGroups((Collection)UserFilterUtils.filterRemovedGroups((Set)filter.getGroups(), (Collection)allGroups)), (Object)"projectRoles", (Object)UserFilterUtils.getProjectRoles((ProjectRoleManager)this.projectRoleManager, (Set)filter.getRoleIds())));
        }
        catch (SoyException e) {
            throw new RuntimeException(e);
        }
    }

    public String getObjectKey() {
        return "userpickerfilter";
    }

    public Object getConfigurationObject(Issue issue, FieldConfig config) {
        return this.userFilterManager.getFilter(config);
    }

    public String getBaseEditUrl() {
        return "EditCustomFieldUserPickerFilter.jspa";
    }
}

