/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.rest.AbstractCustomFieldOperationsHandler;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import java.util.Date;

public class DateCustomFieldOperationsHandler
extends AbstractCustomFieldOperationsHandler<String> {
    private final DateFieldFormat dateFieldFormat;

    public DateCustomFieldOperationsHandler(CustomField field, DateFieldFormat dateFieldFormat, I18nHelper i18nHelper) {
        super(field, i18nHelper);
        this.dateFieldFormat = dateFieldFormat;
    }

    protected String getInitialValue(Issue issue, ErrorCollection errors) {
        Object value = this.field.getValue(issue);
        return value == null ? null : this.dateFieldFormat.formatDatePicker((Date)value);
    }

    protected String getInitialCreateValue(IssueContext issueCtx) {
        return null;
    }

    protected void finaliseOperation(String finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        if (finalValue == null) {
            parameters.addCustomFieldValue(this.field.getId(), null);
        } else {
            Date date = null;
            try {
                date = Dates.fromDateString((String)finalValue);
                parameters.addCustomFieldValue(this.field.getId(), new String[]{this.dateFieldFormat.formatDatePicker(date)});
            }
            catch (IllegalArgumentException e) {
                errors.addError(this.field.getId(), e.getMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
    }

    protected String handleSetOperation(IssueContext issueCtx, Issue issue, String currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        if (!operationValue.isNull() && !operationValue.isString()) {
            errors.addError(this.field.getId(), this.i18nHelper.getText("rest.operation.must.be.string"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return operationValue.asString();
    }
}

