/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager.xml;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.issue.customfields.manager.xml.AllowlistedXStream;
import com.atlassian.jira.issue.customfields.manager.xml.XStreamAllowlistExtensionListener;
import com.atlassian.jira.issue.customfields.manager.xml.XStreamLegacySettings;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.security.serialization.XmlPluginAllowlistProvider;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.base.BaseDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.util.calendar.BaseCalendar;

final class AllowlistedXStreamFactory {
    static final String ALLOWLIST_FILENAME = "xml-local-allowlist";
    private static final Logger log = LoggerFactory.getLogger(AllowlistedXStreamFactory.class);
    private final JiraHome jiraHome;
    private final XStreamAllowlistExtensionListener listener;
    private final XStreamLegacySettings legacySettings;
    private final PluginAccessor pluginManager;

    AllowlistedXStreamFactory(JiraHome jiraHome, XStreamAllowlistExtensionListener listener, PluginAccessor pluginManager) {
        this(jiraHome, listener, new XStreamLegacySettings(), pluginManager);
    }

    @VisibleForTesting
    AllowlistedXStreamFactory(JiraHome jiraHome, XStreamAllowlistExtensionListener listener, XStreamLegacySettings legacySettings, PluginAccessor pluginManager) {
        this.jiraHome = jiraHome;
        this.listener = listener;
        this.legacySettings = legacySettings;
        this.pluginManager = pluginManager;
    }

    AllowlistedXStream create() {
        XStream xstream = new XStream();
        this.fillJiraDefaults(xstream);
        this.legacySettings.fill(xstream);
        AllowlistedXStream allowlisted = new AllowlistedXStream(xstream);
        this.listener.register(allowlisted);
        Sets.SetView preloadedExtensions = Sets.union(this.getExtensionsFromFile(), this.getExtensionsFromAlreadyEnabledPlugins());
        allowlisted.extendAllowlist((Set<String>)preloadedExtensions);
        return allowlisted;
    }

    private void fillJiraDefaults(XStream xstream) {
        xstream.allowTypeHierarchy(CustomFieldParams.class);
        xstream.allowTypeHierarchy(BaseCalendar.Date.class);
        xstream.allowTypeHierarchy(BaseDateTime.class);
        xstream.allowTypes(new Class[]{Timestamp.class});
    }

    private Set<String> getExtensionsFromAlreadyEnabledPlugins() {
        return this.pluginManager.getPlugins().stream().flatMap(p -> p.getModuleDescriptorsByModuleClass(XmlPluginAllowlistProvider.class).stream()).map(ModuleDescriptor::getModule).flatMap(m -> m.getAllowlistedClasses().stream()).collect(Collectors.toSet());
    }

    private Set<String> getExtensionsFromFile() {
        File[] files = this.jiraHome.getHome().listFiles((dir, name) -> ALLOWLIST_FILENAME.equals(name));
        if (files == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(files).findFirst().map(this::readAllowedTypes).orElseGet(Collections::emptySet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> readAllowedTypes(File file) {
        try (Stream<String> lines = Files.lines(file.toPath());){
            Set<String> set = lines.filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toSet());
            return set;
        }
        catch (IOException ex) {
            log.warn("Could not read custom xml deserialization allowlist from file " + file.getAbsolutePath(), (Throwable)ex);
            return Collections.emptySet();
        }
    }
}

