/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager.xml;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.issue.customfields.manager.xml.XStreamLegacySettings;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.InputStream;
import java.util.regex.Pattern;

final class BlocklistedXStreamFactory {
    private final XStreamLegacySettings legacySettings;

    BlocklistedXStreamFactory() {
        this(new XStreamLegacySettings());
    }

    @VisibleForTesting
    BlocklistedXStreamFactory(XStreamLegacySettings legacySettings) {
        this.legacySettings = legacySettings;
    }

    XStream create() {
        XStream xstream = new XStream();
        xstream.addPermission(AnyTypePermission.ANY);
        this.fillDefaults(xstream);
        this.fillWorkaround(xstream);
        this.legacySettings.fill(xstream);
        return xstream;
    }

    private void fillDefaults(XStream xstream) {
        xstream.denyTypes(new String[]{"java.beans.EventHandler", "java.lang.ProcessBuilder", "javax.imageio.ImageIO$ContainsFilter", "jdk.nashorn.internal.objects.NativeString", "com.sun.corba.se.impl.activation.ServerTableEntry", "com.sun.tools.javac.processing.JavacProcessingEnvironment$NameProcessIterator", "sun.awt.datatransfer.DataTransferer$IndexOrderComparator", "sun.swing.SwingLazyValue"});
        xstream.denyTypesByRegExp(new Pattern[]{Pattern.compile(".*\\$LazyIterator"), Pattern.compile(".*\\.Lazy(?:Search)?Enumeration.*"), Pattern.compile(".*\\$GetterSetterReflection"), Pattern.compile(".*\\$PrivilegedGetter"), Pattern.compile("(?:java|sun)\\.rmi\\..*"), Pattern.compile("javax\\.crypto\\..*"), Pattern.compile(".*\\$ServiceNameIterator"), Pattern.compile("javafx\\.collections\\.ObservableList\\$.*"), Pattern.compile(".*\\.bcel\\..*\\.util\\.ClassLoader")});
        xstream.denyTypeHierarchy(InputStream.class);
        this.denyHierarchy(xstream, "java.nio.channels.Channel");
        this.denyHierarchy(xstream, "javax.activation.DataSource");
        this.denyHierarchy(xstream, "javax.sql.rowset.BaseRowSet");
        xstream.allowTypeHierarchy(Exception.class);
    }

    private void fillWorkaround(XStream xstream) {
        xstream.denyTypesByWildcard(new String[]{"sun.reflect.**", "sun.tracing.**", "com.sun.corba.**"});
        xstream.denyTypesByRegExp(new String[]{".*\\.ws\\.client\\.sei\\..*", ".*\\$ProxyLazyValue", "com\\.sun\\.jndi\\..*Enumerat(?:ion|tor)", ".*\\$URLData", ".*\\.xsltc\\.trax\\.TemplatesImpl"});
        xstream.denyTypes(new String[]{"org.apache.commons.collections.comparators.TransformingComparator", "org.apache.commons.collections.comparators.ComparableComparator", "org.apache.commons.collections.functors.InvokerTransformer", "org.apache.xalan.xsltc.trax.TemplatesImpl"});
    }

    private void denyHierarchy(XStream xstream, String className) {
        Class type = JVM.loadClassForName((String)className);
        if (type != null) {
            xstream.denyTypeHierarchy(type);
        }
    }
}

