/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager.xml;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.issue.customfields.manager.xml.AllowlistedXStream;
import com.atlassian.jira.issue.customfields.manager.xml.AllowlistedXStreamFactory;
import com.atlassian.jira.issue.customfields.manager.xml.BlocklistedXStreamFactory;
import com.atlassian.jira.issue.customfields.manager.xml.XStreamAllowlistExtensionListener;
import com.atlassian.jira.util.XmlConverter;
import com.atlassian.plugin.PluginAccessor;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.ForbiddenClassException;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultXmlConverter
implements XmlConverter {
    private static final Logger log = LoggerFactory.getLogger(DefaultXmlConverter.class);
    private final FeatureManager featureManager;
    private final AllowlistedXStream withAllowlist;
    private final XStream withBlocklist;

    public DefaultXmlConverter(JiraHome jiraHome, XStreamAllowlistExtensionListener listener, FeatureManager featureManager, PluginAccessor pluginManager) {
        this(featureManager, new AllowlistedXStreamFactory(jiraHome, listener, pluginManager).create(), new BlocklistedXStreamFactory().create());
    }

    DefaultXmlConverter(FeatureManager featureManager, AllowlistedXStream withAllowlist, XStream withBlocklist) {
        this.featureManager = featureManager;
        this.withAllowlist = withAllowlist;
        this.withBlocklist = withBlocklist;
    }

    public String toXml(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        return this.withBlocklist.toXML(obj);
    }

    public Object fromXml(@Nullable String xml) {
        if (StringUtils.isEmpty((CharSequence)xml)) {
            return null;
        }
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.XML_DESERIALIZER_ALLOWLIST)) {
            try {
                return this.withAllowlist.fromXML(xml);
            }
            catch (ForbiddenClassException ex) {
                log.warn("Deserialization of '{}' was blocked. Consider adding it to the allowlist.", (Object)ex.getMessage());
                throw ex;
            }
            catch (ConversionException ex) {
                if (ex.getCause() instanceof ForbiddenClassException) {
                    log.warn("Deserialization of '{}' was blocked. Consider adding it to the allowlist.", (Object)ex.getCause().getMessage());
                }
                throw ex;
            }
        }
        return this.withBlocklist.fromXML(xml);
    }
}

