/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.persistence;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldRetrievalHelper;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValue;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValues;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.util.CollectionUtils;

public class OfBizCustomFieldValuePersister
implements CustomFieldValuePersister {
    protected final OfBizDelegator delegator;
    private final Clock clock;
    static final String ENTITY_ID = "id";
    public static final String ENTITY_VALUE_TYPE = "valuetype";
    public static final String ENTITY_ISSUE_ID = "issue";
    protected static final String ENTITY_CUSTOMFIELD_ID = "customfield";
    protected static final String ENTITY_PARENT_KEY = "parentkey";
    static final String ENTITY_UPDATED = "updated";
    public static final String DEFAULT_VALUE_TYPE = "DEFAULT";
    public static final String FIELD_TYPE_STRING = "stringvalue";
    public static final String FIELD_TYPE_TEXT = "textvalue";
    public static final String FIELD_TYPE_DATE = "datevalue";
    public static final String FIELD_TYPE_NUMBER = "numbervalue";
    private static final Map<PersistenceFieldType, String> DB_FIELD_MAPPING = new HashMap<PersistenceFieldType, String>();
    public static final String TABLE_CUSTOMFIELD_VALUE = "CustomFieldValue";
    public static final Long DEFAULT_VALUE_ISSUE_ID;

    public OfBizCustomFieldValuePersister(OfBizDelegator delegator, Clock clock) {
        this.delegator = delegator;
        this.clock = clock;
    }

    public List<Object> getValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType) {
        return this.getValues(field, issueId, persistenceFieldType, null);
    }

    public List<Object> getValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, String parentKey) {
        if (issueId == null) {
            return Collections.emptyList();
        }
        List<GenericValue> genericValues = this.getValuesForTypeAndParent(field, issueId, parentKey);
        return OfBizCustomFieldValuePersister.getValuesFromGenericValues(genericValues, persistenceFieldType);
    }

    public Set<Long> getIssueIdsWithValue(CustomField field, PersistenceFieldType persistenceFieldType, Object value) {
        Map limitClause = MapBuilder.build((Object)ENTITY_VALUE_TYPE, null, (Object)ENTITY_CUSTOMFIELD_ID, (Object)CustomFieldUtils.getCustomFieldId((String)field.getId()), (Object)OfBizCustomFieldValuePersister.getColumnName(persistenceFieldType), (Object)value);
        return this.delegator.findByAnd(TABLE_CUSTOMFIELD_VALUE, limitClause).stream().map(gv -> gv.getLong(ENTITY_ISSUE_ID)).collect(Collectors.toSet());
    }

    static List<Object> getValuesFromGenericValues(Collection<GenericValue> genericValues, PersistenceFieldType persistenceFieldType) {
        return genericValues.stream().map(gv -> gv.get(OfBizCustomFieldValuePersister.getColumnName(persistenceFieldType))).collect(Collectors.toList());
    }

    public void createValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values) {
        this.createValues(field, issueId, persistenceFieldType, values, null);
    }

    public void createValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values, String parentKey) {
        this.updateValues(field, issueId, persistenceFieldType, values, parentKey);
    }

    private void createValuesInt(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values, String parentKey) {
        if (values == null) {
            return;
        }
        long time = this.clock.getCurrentDate().getTime();
        for (Object value : values) {
            if (value == null || "".equals(value) || "-1".equals(value)) continue;
            HashMap<String, Object> entityFields = new HashMap<String, Object>();
            entityFields.put(ENTITY_ISSUE_ID, issueId);
            entityFields.put(ENTITY_PARENT_KEY, parentKey);
            entityFields.put(ENTITY_CUSTOMFIELD_ID, CustomFieldUtils.getCustomFieldId((String)field.getId()));
            entityFields.put(OfBizCustomFieldValuePersister.getColumnName(persistenceFieldType), value);
            entityFields.put(ENTITY_UPDATED, time);
            this.delegator.createValue(TABLE_CUSTOMFIELD_VALUE, entityFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values) {
        Transaction transaction = Txn.begin();
        try {
            List<GenericValue> GVs = this.getValuesForType(field, issueId);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)values)) {
                this.createValuesInt(field, issueId, persistenceFieldType, values, null);
            }
            this.delegator.removeAll(GVs);
            transaction.commit();
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values, String parentKey) {
        Transaction transaction = Txn.begin();
        try {
            List<GenericValue> GVs = this.getValuesForTypeAndParent(field, issueId, parentKey);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)values)) {
                this.createValuesInt(field, issueId, persistenceFieldType, values, parentKey);
            }
            this.delegator.removeAll(GVs);
            transaction.commit();
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }

    public Map<Long, List<CustomFieldValue>> getValues(Set<Long> issueIds) {
        if (CollectionUtils.isEmpty(issueIds)) {
            return Collections.emptyMap();
        }
        return this.getValuesForIssueIds(issueIds).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> CustomFieldValues.fromOrderedByUpdate((Collection)entry.getValue())));
    }

    public Set<Long> removeValue(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Object value) {
        Map limitClause = MapBuilder.build((Object)ENTITY_CUSTOMFIELD_ID, (Object)CustomFieldUtils.getCustomFieldId((String)field.getId()), (Object)ENTITY_ISSUE_ID, (Object)issueId, (Object)OfBizCustomFieldValuePersister.getColumnName(persistenceFieldType), (Object)value);
        List values = this.delegator.findByAnd(TABLE_CUSTOMFIELD_VALUE, limitClause);
        Set<Long> issueIds = values.stream().map(valueGV -> valueGV.getLong(ENTITY_ISSUE_ID)).collect(Collectors.toSet());
        this.delegator.removeAll(values);
        return issueIds;
    }

    public Set<Long> removeAllValues(String customFieldId) {
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        Map limitClause = MapBuilder.build((Object)ENTITY_CUSTOMFIELD_ID, (Object)CustomFieldUtils.getCustomFieldId((String)customFieldId));
        List values = this.delegator.findByAnd(TABLE_CUSTOMFIELD_VALUE, limitClause);
        Set<Long> issueIds = values.stream().map(valueGV -> valueGV.getLong(ENTITY_ISSUE_ID)).filter(issueId -> issueId != null && !issueId.equals(DEFAULT_VALUE_ISSUE_ID)).collect(Collectors.toSet());
        this.delegator.removeAll(values);
        return issueIds;
    }

    protected List<GenericValue> getValuesForTypeAndParent(CustomField field, Long issueId, String parentKey) {
        Map limitClause = MapBuilder.build((Object)ENTITY_ISSUE_ID, (Object)issueId, (Object)ENTITY_CUSTOMFIELD_ID, (Object)CustomFieldUtils.getCustomFieldId((String)field.getId()), (Object)ENTITY_PARENT_KEY, (Object)parentKey);
        return CustomFieldRetrievalHelper.getValuesOrderedByUpdate(this.delegator, limitClause);
    }

    protected List<GenericValue> getValuesForType(CustomField field, Long issueId) {
        Map limitClause = MapBuilder.build((Object)ENTITY_ISSUE_ID, (Object)issueId, (Object)ENTITY_CUSTOMFIELD_ID, (Object)CustomFieldUtils.getCustomFieldId((String)field.getId()));
        return CustomFieldRetrievalHelper.getValuesOrderedByUpdate(this.delegator, limitClause);
    }

    private static String getColumnName(PersistenceFieldType persistenceFieldType) {
        String columnName = DB_FIELD_MAPPING.get(persistenceFieldType);
        Preconditions.checkArgument((columnName != null ? 1 : 0) != 0, (Object)("PersistenceFieldType '" + persistenceFieldType + "' not supported. Supported types: '" + DB_FIELD_MAPPING.keySet() + "'"));
        return columnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, List<GenericValue>> getValuesForIssueIds(Set<Long> issueIds) {
        try (OfBizListIterator iterator = this.delegator.findListIteratorByCondition(TABLE_CUSTOMFIELD_VALUE, (EntityCondition)new EntityExpr(ENTITY_ISSUE_ID, EntityOperator.IN, issueIds));){
            Map<Long, List<GenericValue>> map = iterator.getCompleteList().stream().collect(Collectors.groupingBy(value -> value.getLong(ENTITY_ISSUE_ID)));
            return map;
        }
    }

    static {
        DB_FIELD_MAPPING.put(PersistenceFieldType.TYPE_DATE, FIELD_TYPE_DATE);
        DB_FIELD_MAPPING.put(PersistenceFieldType.TYPE_DECIMAL, FIELD_TYPE_NUMBER);
        DB_FIELD_MAPPING.put(PersistenceFieldType.TYPE_LIMITED_TEXT, FIELD_TYPE_STRING);
        DB_FIELD_MAPPING.put(PersistenceFieldType.TYPE_UNLIMITED_TEXT, FIELD_TYPE_TEXT);
        DEFAULT_VALUE_ISSUE_ID = -1L;
    }
}

