/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.export.customfield;

import com.atlassian.jira.issue.export.customfield.DelimiterResolver;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;

public class ExportUtils {
    public static final CharSequenceTranslator CUSTOM_CSV_ESCAPER = new CustomCsvEscaper();

    private static class CustomCsvEscaper
    extends CharSequenceTranslator {
        private static final char DOUBLE_QUOTE = '\"';
        private static final String DOUBLE_QUOTE_STRING = String.valueOf('\"');
        private static final List<Character> BASIC_CHARS = ImmutableList.of((Object)Character.valueOf('\r'), (Object)Character.valueOf('\n'), (Object)Character.valueOf('\"'));
        private static final char[] SEARCH_CHARS = new char[BASIC_CHARS.size() + DelimiterResolver.ALLOWED_DELIMITERS.size()];

        private CustomCsvEscaper() {
        }

        public int translate(CharSequence input, int index, Writer out) throws IOException {
            String value = input.toString();
            if (StringUtils.containsNone((CharSequence)value, (char[])SEARCH_CHARS)) {
                out.write(value);
            } else {
                this.escape(value, out);
            }
            return Character.codePointCount(input, 0, input.length());
        }

        private void escape(String value, Writer out) throws IOException {
            out.write(34);
            out.write(StringUtils.replace((String)value, (String)DOUBLE_QUOTE_STRING, (String)(DOUBLE_QUOTE_STRING + DOUBLE_QUOTE_STRING)));
            out.write(34);
        }

        static {
            ArrayList combinedChars = Lists.newArrayList((Iterable)Iterables.concat(BASIC_CHARS, DelimiterResolver.ALLOWED_DELIMITERS));
            for (int i = 0; i < SEARCH_CHARS.length; ++i) {
                CustomCsvEscaper.SEARCH_CHARS[i] = ((Character)combinedChars.get(i)).charValue();
            }
        }
    }
}

