/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.AbstractOrderableField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MappedSortComparator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CompositeMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;

public abstract class AbstractOrderableNavigableFieldImpl<V>
extends AbstractOrderableField<V>
implements NavigableField {
    protected AbstractOrderableNavigableFieldImpl(String id, String name, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, SearchHandlerFactory searchHandlerFactory) {
        super(id, name, templatingEngine, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
    }

    protected Map<String, Object> getVelocityParams(I18nHelper isI18nHelper, Map<String, Object> displayParams, Issue issue) {
        Map<String, Object> velocityParams = super.getVelocityParams(displayParams);
        velocityParams.put("i18n", isI18nHelper);
        return CompositeMap.of(velocityParams, this.getVelocityParams(issue));
    }

    public FieldComparatorSource getSortComparatorSource() {
        return new MappedSortComparator(this.getSorter());
    }

    public List<SortField> getSortFields(boolean sortOrder) {
        String fieldName = this.getSorter().getDocumentConstant();
        return Collections.singletonList(new SortField(fieldName, this.getSortComparatorSource(), sortOrder));
    }

    public String getColumnCssClass() {
        return this.getId();
    }

    public String getHiddenFieldId() {
        return this.getId();
    }

    public String prettyPrintChangeHistory(String changeHistory) {
        return changeHistory;
    }

    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        return changeHistory;
    }
}

