/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.NumberTool;
import java.util.Map;
import webwork.action.Action;

public abstract class AbstractPickerFieldImpl<V>
extends AbstractOrderableNavigableFieldImpl<V> {
    protected static final int DEFAULT_MAX_OPTIONS_VALUE = 100;
    public static final String MAX_OPTIONS_NUMBER = "maxOptionsNumber";

    protected AbstractPickerFieldImpl(String id, String name, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, SearchHandlerFactory searchHandlerFactory) {
        super(id, name, templatingEngine, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
    }

    protected Map<String, Object> getVelocityParams(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map<String, Object> displayParams, I18nHelper isI18nHelper) {
        Map<String, Object> velocityParams = super.getVelocityParams(fieldLayoutItem, action, issue, displayParams);
        velocityParams.put(MAX_OPTIONS_NUMBER, 100);
        velocityParams.put("numberTool", new NumberTool(isI18nHelper.getLocale()));
        return velocityParams;
    }

    protected boolean shouldUseRestEndpoint(OperationContext operationContext) {
        IssueOperation issueOperation = operationContext.getIssueOperation();
        return issueOperation != null && issueOperation.getNameKey() != null && this.userPickerEnabled(operationContext);
    }

    protected boolean userPickerEnabled(OperationContext operationContext) {
        return operationContext.getFieldValuesHolder().getOrDefault("usePicker", false);
    }
}

