/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.AbstractPickerFieldImpl;
import com.atlassian.jira.issue.fields.ComponentsField;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.LongIdsValueHolder;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.event.ComponentCreatedInlineEvent;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.issue.fields.rest.ComponentsRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.ComponentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.ComponentSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.ComponentStatisticsMapper;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.views.SearchLinkGenerator;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.DefaultBulkMoveHelper;
import com.atlassian.query.order.SortOrder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;

public class ComponentsSystemField
extends AbstractPickerFieldImpl<Collection<ProjectComponent>>
implements HideableField,
RequirableField,
ComponentsField,
RestAwareField,
RestFieldOperations,
ExportableSystemField {
    private static final Logger log = LoggerFactory.getLogger(ComponentsSystemField.class);
    private static final String COMPONENTS_PARAM = "components";
    private static final String COMPONENTS_NAME_KEY = "issue.field.components";
    public static final String CHANGE_ITEM_FIELD = "Component";
    private static final Long UNKNOWN_COMPONENTS_ID = -1L;
    private final ProjectComponentManager projectComponentManager;
    private final ComponentStatisticsMapper componentStatisticsMapper;
    private final ProjectManager projectManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final EventPublisher eventPublisher;
    private final SearchLinkGenerator searchLinkGenerator;
    private final JqlStringSupport jqlStringSupport;
    private final Predicate<Long> validComponentId = new Predicate<Long>(){

        public boolean apply(Long componentId) {
            try {
                if (UNKNOWN_COMPONENTS_ID.equals(componentId)) {
                    return true;
                }
                ProjectComponent component = ComponentsSystemField.this.projectComponentManager.find(componentId);
                return true;
            }
            catch (EntityNotFoundException e) {
                return false;
            }
        }
    };
    public static final com.atlassian.jira.util.Function<ProjectComponent, Long> COMPONENT_TO_ID_TRANSFORMER = input -> input.getId();

    public ComponentsSystemField(VelocityTemplatingEngine templatingEngine, ProjectComponentManager projectComponentManager, ApplicationProperties applicationProperties, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, ComponentStatisticsMapper componentStatisticsMapper, ComponentSearchHandlerFactory componentSearchHandlerFactory, ProjectManager projectManager, JiraBaseUrls jiraBaseUrls, EventPublisher eventPublisher, SearchLinkGenerator searchLinkGenerator, JqlStringSupport jqlStringSupport) {
        super(COMPONENTS_PARAM, COMPONENTS_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, componentSearchHandlerFactory);
        this.projectComponentManager = projectComponentManager;
        this.componentStatisticsMapper = componentStatisticsMapper;
        this.projectManager = projectManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.eventPublisher = eventPublisher;
        this.searchLinkGenerator = searchLinkGenerator;
        this.jqlStringSupport = jqlStringSupport;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map dispayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, dispayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        boolean useRestEndpoint;
        com.atlassian.jira.util.Function getArchivedComponentJQL = component -> JiraUrlCodec.encode((String)this.jqlStringSupport.generateJqlString(JqlQueryBuilder.newBuilder().where().project(new Long[]{issue.getProjectObject().getId()}).and().component(new String[]{component.getName()}).endWhere().orderBy().priority(SortOrder.ASC).buildQuery()));
        LongIdsValueHolder currentComponentsIds = LongIdsValueHolder.fromFieldValuesHolder(this.getId(), operationContext.getFieldValuesHolder());
        if (currentComponentsIds != null) {
            currentComponentsIds.validateIds(this.validComponentId);
        }
        Collection<ProjectComponent> possibleComponents = this.getComponents(issue.getProjectId());
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters, this.getAuthenticationContext().getI18nHelper());
        velocityParams.put("currentComponentsIds", currentComponentsIds);
        velocityParams.put("currentComponents", this.getCurrentComponents(possibleComponents, currentComponentsIds));
        velocityParams.put("frotherInputText", currentComponentsIds == null ? null : currentComponentsIds.getInputText());
        velocityParams.put(COMPONENTS_PARAM, possibleComponents);
        velocityParams.put("unknownComponentId", UNKNOWN_COMPONENTS_ID);
        velocityParams.put("archivedComponents", this.getArchivedComponentsThatAreSelected(issue, issue.getComponents()));
        velocityParams.put("getArchivedComponentJQL", getArchivedComponentJQL);
        velocityParams.put("archivedComponentsTitle", "issue.field.archived.components");
        velocityParams.put("project", issue.getProject());
        if (fieldLayoutItem != null) {
            velocityParams.put("isFrotherControl", HackyRendererType.fromKey((String)fieldLayoutItem.getRendererType()) == HackyRendererType.FROTHER_CONTROL);
        }
        velocityParams.put("createPermission", this.getPermissionManager().hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, issue.getProjectObject(), this.authenticationContext.getUser()));
        if (displayParameters.get("bulkEdit") != null) {
            velocityParams.put("bulkEdit", displayParameters.get("bulkEdit"));
        }
        if (useRestEndpoint = this.shouldUseRestEndpoint(operationContext)) {
            velocityParams.put("useRestEndpoint", "admin.issue.operations.edit".equals(operationContext.getIssueOperation().getNameKey()) || "admin.issue.operations.create".equals(operationContext.getIssueOperation().getNameKey()));
        }
        if (possibleComponents != null && !possibleComponents.isEmpty()) {
            int limit = useRestEndpoint ? 100 : possibleComponents.size();
            velocityParams.put("limit", limit);
        }
        return this.renderTemplate("components-edit.vm", velocityParams);
    }

    private List<ProjectComponent> getCurrentComponents(Collection<ProjectComponent> possibleComponents, LongIdsValueHolder currentComponentsIds) {
        if (currentComponentsIds == null || possibleComponents == null) {
            return Collections.emptyList();
        }
        return possibleComponents.stream().filter(component -> currentComponentsIds.contains(component.getId())).collect(Collectors.toList());
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Assertions.notNull((String)"bulkEditBean", (Object)bulkEditBean);
        Assertions.notEmpty((String)"selectedIssues", (Collection)bulkEditBean.getSelectedIssues());
        if ("BulkMove".equals(bulkEditBean.getOperationName())) {
            FieldLayoutItem fieldLayoutItem = bulkEditBean.getTargetFieldLayout().getFieldLayoutItem((OrderableField)this);
            DefaultBulkMoveHelper bulkMoveHelper = new DefaultBulkMoveHelper();
            com.atlassian.jira.util.Function componentNameResolver = input -> {
                try {
                    return this.projectComponentManager.find((Long)input).getName();
                }
                catch (EntityNotFoundException e) {
                    throw new RuntimeException(e);
                }
            };
            com.atlassian.jira.util.Function issueValueResolver = input -> {
                LinkedHashMap<String, Object> fieldValuesHolder = new LinkedHashMap<String, Object>();
                this.populateFromIssue((Map<String, Object>)fieldValuesHolder, (Issue)input);
                return (Collection)fieldValuesHolder.get(this.getId());
            };
            Map distinctComponentValues = bulkMoveHelper.getDistinctValuesForMove(bulkEditBean, this, issueValueResolver, componentNameResolver);
            Issue issue = bulkEditBean.getFirstTargetIssueObject();
            Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
            velocityParams.put("valuesToMap", distinctComponentValues);
            velocityParams.put("bulkMoveHelper", bulkMoveHelper);
            velocityParams.put(COMPONENTS_PARAM, this.getComponents(issue.getProjectId()));
            velocityParams.put("unknownComponentId", UNKNOWN_COMPONENTS_ID);
            if (fieldLayoutItem != null) {
                velocityParams.put("isFrotherControl", HackyRendererType.fromKey((String)fieldLayoutItem.getRendererType()) == HackyRendererType.FROTHER_CONTROL);
            }
            return this.renderTemplate("components-bulkmove.vm", velocityParams);
        }
        return super.getBulkEditHtml(operationContext, action, bulkEditBean, displayParameters);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put(COMPONENTS_PARAM, issue.getComponentObjects());
        velocityParams.put("projectManager", this.projectManager);
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Collection<ProjectComponent> value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put(COMPONENTS_PARAM, value);
        velocityParams.put("projectManager", this.projectManager);
        return this.getViewHtml(velocityParams);
    }

    private String getViewHtml(Map velocityParams) {
        return this.renderTemplate("components-view.vm", velocityParams);
    }

    private Collection<ProjectComponent> getComponents(Project project) {
        return this.getComponents(project.getId());
    }

    private Collection<ProjectComponent> getComponents(Long projectId) {
        return this.projectComponentManager.findAllActiveForProject(projectId);
    }

    private Collection<ProjectComponent> getArchivedComponentsThatAreSelected(Issue issue, Collection<ProjectComponent> selectedComponents) {
        Collection archivedComponents = this.projectComponentManager.findAllArchivedForProject(issue.getProjectId()).stream().filter(component -> !component.isDeleted()).collect(Collectors.toList());
        archivedComponents.retainAll(selectedComponents);
        return archivedComponents;
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        LongIdsValueHolder componentIds = LongIdsValueHolder.fromFieldValuesHolder(this.getId(), fieldValuesHolder);
        Project project = issue.getProjectObject();
        if (componentIds != null && componentIds.size() > 1) {
            for (Object componentId : componentIds) {
                Long l = (Long)componentId;
                if (!UNKNOWN_COMPONENTS_ID.equals(l)) continue;
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.components.noneselectedwithother"), ErrorCollection.Reason.VALIDATION_FAILED);
                return;
            }
        }
        if (this.validateForRequiredField(errorCollectionToAddTo, i18n, fieldScreenRenderLayoutItem, componentIds, project)) {
            this.validateComponentForProject(errorCollectionToAddTo, i18n, componentIds, project);
        }
        if (componentIds != null) {
            if (this.getPermissionManager().hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, issue.getProjectObject(), this.authenticationContext.getUser())) {
                for (String componentName : componentIds.getValuesToAdd()) {
                    if (StringUtils.isBlank((CharSequence)componentName)) {
                        errorCollectionToAddTo.addError(this.getId(), i18n.getText("admin.projects.component.namenotset"), ErrorCollection.Reason.VALIDATION_FAILED);
                        continue;
                    }
                    ProjectComponent component = this.projectComponentManager.findByComponentName(project.getId(), componentName);
                    if (component == null) continue;
                    if (component.isArchived()) {
                        errorCollectionToAddTo.addError(this.getId(), i18n.getText("admin.projects.component.archived.exists"), ErrorCollection.Reason.VALIDATION_FAILED);
                        continue;
                    }
                    errorCollectionToAddTo.addError(this.getId(), i18n.getText("admin.projects.component.namenotunique", component.getName()), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            } else {
                String bad = componentIds.getInputText();
                if (StringUtils.isNotBlank((CharSequence)bad)) {
                    errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.components.components.does.not.exist", bad), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            }
        }
    }

    @VisibleForTesting
    boolean validateForRequiredField(ErrorCollection errorCollectionToAddTo, I18nHelper i18n, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem, LongIdsValueHolder componentIds, Project project) {
        boolean noNewComponentsSpecified;
        boolean noExistingComponentsSpecified = componentIds == null || componentIds.isEmpty() || componentIds.contains(UNKNOWN_COMPONENTS_ID);
        boolean bl = noNewComponentsSpecified = componentIds != null && componentIds.getValuesToAdd().isEmpty();
        if (fieldScreenRenderLayoutItem != null && fieldScreenRenderLayoutItem.isRequired() && noExistingComponentsSpecified && noNewComponentsSpecified) {
            Collection<ProjectComponent> components = this.getComponents(project);
            if (components.isEmpty()) {
                errorCollectionToAddTo.addErrorMessage(i18n.getText("createissue.error.components.required", i18n.getText(this.getNameKey()), project.getName()), ErrorCollection.Reason.VALIDATION_FAILED);
            } else {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())), ErrorCollection.Reason.VALIDATION_FAILED);
            }
            return false;
        }
        return true;
    }

    private void validateComponentForProject(ErrorCollection errorCollectionToAddTo, I18nHelper i18n, LongIdsValueHolder componentIds, Project project) {
        if (componentIds != null) {
            StringBuilder sb = null;
            for (Long componentId : componentIds) {
                if (componentId == -1L) {
                    return;
                }
                try {
                    ProjectComponent component = this.projectComponentManager.find(componentId);
                    if (component.getProjectId().equals(project.getId())) continue;
                    if (sb == null) {
                        sb = new StringBuilder(component.getName()).append("(").append(component.getId()).append(")");
                        continue;
                    }
                    sb.append(", ").append(component.getName()).append("(").append(component.getId()).append(")");
                }
                catch (EntityNotFoundException e) {
                    componentIds.addBadId(componentId);
                    return;
                }
            }
            if (sb != null) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.components.components.not.valid.for.project", sb.toString(), project.getName()), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> params) {
        String[] value = params.get(this.getId());
        LongIdsValueHolder vh = new LongIdsValueHolder(value);
        vh.validateIds(this.validComponentId);
        return vh;
    }

    public Collection<ProjectComponent> getValueFromParams(Map params) {
        List<ProjectComponent> components = this.getComponentsFromParams(params);
        if (components == null) {
            return Collections.emptyList();
        }
        return components;
    }

    public List<ProjectComponent> getComponentsFromParams(Map params) {
        LongIdsValueHolder componentIds = LongIdsValueHolder.fromFieldValuesHolder(this.getId(), params);
        if (componentIds == null) {
            return null;
        }
        if (componentIds.isEmpty() || componentIds.contains(UNKNOWN_COMPONENTS_ID)) {
            return Collections.emptyList();
        }
        try {
            return this.projectComponentManager.getComponents((List)componentIds);
        }
        catch (EntityNotFoundException e) {
            throw new FieldValidationException("Trying to retrieve non existant component");
        }
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        fieldValuesHolder.put(this.getId(), new LongIdsValueHolder(this.getComponentIds(issue, stringValue)));
    }

    private List<Long> getComponentIds(Issue issue, String stringValue) throws FieldValidationException {
        HashSet<Long> components = new HashSet<Long>();
        Project project = issue.getProjectObject();
        if (TextUtils.stringSet((String)stringValue)) {
            String[] componentParams;
            for (String componentParam : componentParams = StringUtils.split((String)stringValue, (String)",")) {
                try {
                    components.add(Long.valueOf(componentParam));
                }
                catch (NumberFormatException e) {
                    ProjectComponent component = this.projectComponentManager.findByComponentName(project.getId(), componentParam);
                    if (component != null) {
                        components.add(component.getId());
                        continue;
                    }
                    throw new FieldValidationException("Invalid component name '" + componentParam + "'.");
                }
            }
        }
        return new ArrayList<Long>(components);
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Collection currentComponents = (Collection)modifiedValue.getOldValue();
        Collection<ProjectComponent> newComponents = this.getUpdatedComponents(issue, (Collection)modifiedValue.getNewValue(), currentComponents);
        if (currentComponents == null || currentComponents.isEmpty()) {
            if (newComponents != null) {
                issueChangeHolder.addChangeItems(this.updateIssueValue(issue, newComponents));
            }
        } else if (!this.compareIdSets(newComponents, currentComponents)) {
            issueChangeHolder.addChangeItems(this.updateIssueValue(issue, newComponents));
        }
    }

    private Collection<ProjectComponent> getUpdatedComponents(Issue issue, Collection<ProjectComponent> selectedComponents, Collection<ProjectComponent> currentComponents) {
        Collection<ProjectComponent> affectedComponents = this.getArchivedComponentsThatAreSelected(issue, currentComponents);
        if (affectedComponents != null && !affectedComponents.isEmpty()) {
            if (selectedComponents == null || selectedComponents.isEmpty()) {
                selectedComponents = new ArrayList<ProjectComponent>();
            }
            selectedComponents.addAll(affectedComponents);
        }
        return selectedComponents;
    }

    protected boolean compareIdSets(Collection<ProjectComponent> newComponent, Collection<ProjectComponent> currentComponent) {
        if (newComponent != null && currentComponent != null) {
            ImmutableSet newComponentIds = ImmutableSet.copyOf((Collection)CollectionUtil.transform(newComponent, COMPONENT_TO_ID_TRANSFORMER));
            ImmutableSet currentComponentIds = ImmutableSet.copyOf((Collection)CollectionUtil.transform(currentComponent, COMPONENT_TO_ID_TRANSFORMER));
            return this.valuesEqual(newComponentIds, currentComponentIds);
        }
        return newComponent == null && currentComponent == null;
    }

    private List updateIssueValue(Issue issue, Collection<ProjectComponent> value) {
        return this.projectComponentManager.updateIssueProjectComponents(issue, value);
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), new LongIdsValueHolder(Collections.emptyList()));
    }

    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
        Collection components = issue.getComponentObjects();
        if (components != null) {
            LinkedList<Long> componentIds = new LinkedList<Long>();
            for (ProjectComponent component : components) {
                componentIds.add(component.getId());
            }
            fieldValuesHolder.put(this.getId(), new LongIdsValueHolder((List<Long>)componentIds));
        } else {
            fieldValuesHolder.put(this.getId(), null);
        }
    }

    public Collection<ProjectComponent> getDefaultValue(Issue issue) {
        return Collections.emptyList();
    }

    public void createValue(Issue issue, Collection<ProjectComponent> value) {
        this.updateIssueValue(issue, value);
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        LongIdsValueHolder components = LongIdsValueHolder.fromFieldValuesHolder(this.getId(), fieldValueHolder);
        if (components != null) {
            Set<String> componentNames = components.getValuesToAdd();
            ArrayList allComponents = Lists.newArrayList();
            for (String componentName : componentNames) {
                ProjectComponent newComponent = this.projectComponentManager.create(componentName, null, null, 0L, issue.getProjectId());
                allComponents.add(newComponent);
                this.eventPublisher.publish((Object)new ComponentCreatedInlineEvent(newComponent));
            }
            allComponents.addAll(this.getComponentsFromParams(fieldValueHolder));
            if (!components.getValuesToAdd().isEmpty()) {
                Iterable componentIds = Iterables.transform((Iterable)allComponents, (Function)new Function<ProjectComponent, Long>(){

                    public Long apply(ProjectComponent input) {
                        return input.getId();
                    }
                });
                fieldValueHolder.put(this.getId(), new LongIdsValueHolder(Lists.newArrayList((Iterable)componentIds)));
            }
            issue.setComponent((Collection)allComponents);
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Issue originalIssue : originalIssues) {
            if (this.projectMoved(originalIssue, targetIssue)) {
                if (originalIssue.getComponentObjects().isEmpty()) {
                    if (!targetFieldLayoutItem.isRequired()) continue;
                    return new MessagedResult(true);
                }
                return new MessagedResult(true);
            }
            if (!originalIssue.getComponentObjects().isEmpty() || !targetFieldLayoutItem.isRequired()) continue;
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    private boolean projectMoved(Issue originalIssue, Issue targetIssue) {
        Long targetProjectId;
        Long originalProjectId = originalIssue.getProjectId();
        return !originalProjectId.equals(targetProjectId = targetIssue.getProjectId());
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        Collection<String> currentComponentNames = this.getComponentNames(originalIssue.getComponentObjects());
        Collection<ProjectComponent> possibleComponents = this.getComponents(targetIssue.getProjectId());
        LinkedList<Long> componentIds = new LinkedList<Long>();
        for (ProjectComponent possibleComponent : possibleComponents) {
            if (!currentComponentNames.contains(possibleComponent.getName())) continue;
            componentIds.add(possibleComponent.getId());
        }
        fieldValuesHolder.put(this.getId(), new LongIdsValueHolder((List<Long>)componentIds));
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setComponent(Collections.emptyList());
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public boolean hasValue(Issue issue) {
        Collection components = issue.getComponentObjects();
        return components != null && !components.isEmpty();
    }

    private Collection<String> getComponentNames(Collection<ProjectComponent> components) {
        HashSet<String> componentNames = new HashSet<String>();
        for (ProjectComponent component : components) {
            componentNames.add(component.getName());
        }
        return componentNames;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (bulkEditBean.isMultipleProjects()) {
            return "bulk.edit.unavailable.multipleprojects";
        }
        Project project = bulkEditBean.getSingleProject();
        if (this.projectComponentManager.findAllForProject(project.getId()).isEmpty()) {
            return "bulk.edit.unavailable.nocomponents";
        }
        for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
            if (!fieldLayout.isFieldHidden(this.getId())) continue;
            return "bulk.edit.unavailable.hidden";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.unavailable.permission";
        }
        return null;
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.components";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return this.componentStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put(COMPONENTS_PARAM, issue.getComponentObjects());
        velocityParams.put("searchLinkGenerator", this.searchLinkGenerator);
        return this.renderTemplate("components-columnview.vm", velocityParams);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        Collection<ProjectComponent> components = this.getComponents(fieldTypeInfoContext.getIssueContext().getProjectId());
        return new FieldTypeInfo(components, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.systemArray((String)"component", (String)this.getId());
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new ComponentsRestFieldOperationsHandler(this.projectComponentManager, this.authenticationContext.getI18nHelper());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        Collection components = issue.getComponentObjects();
        Collection beans = ComponentJsonBean.shortBeans((Collection)components, (JiraBaseUrls)this.jiraBaseUrls);
        return new FieldJsonRepresentation(new JsonData((Object)beans));
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return null;
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        Collection components = issue.getComponents();
        if (components != null) {
            Stream<String> values = components.stream().map(ProjectComponent::getName);
            return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), values);
        }
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), Stream.empty());
    }
}

