/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.CustomFieldScope;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.LazyReference;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class CustomFieldScopeImpl
implements CustomFieldScope {
    private final CustomField customField;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private LazyReference<List<FieldConfigScheme>> customFieldSchemes = new LazyReference<List<FieldConfigScheme>>(){

        protected List<FieldConfigScheme> create() throws Exception {
            return CustomFieldScopeImpl.this.fieldConfigSchemeManager.getConfigSchemesForField((ConfigurableField)CustomFieldScopeImpl.this.customField);
        }
    };

    CustomFieldScopeImpl(CustomField customField, FieldConfigSchemeManager fieldConfigSchemeManager) {
        this.customField = customField;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
    }

    @Override
    public boolean isIncludedIn(IssueContext issueContext) {
        List customFieldSchemes = (List)this.customFieldSchemes.get();
        if (customFieldSchemes == null || customFieldSchemes.isEmpty()) {
            return false;
        }
        if (this.searchingForAnyProjectAndAnyIssueType(issueContext)) {
            return true;
        }
        if (this.searchingForAnyProject(issueContext)) {
            return Iterables.any((Iterable)customFieldSchemes, this.inScopeByIssueType(issueContext));
        }
        if (this.searchingForAnyIssueType(issueContext)) {
            return Iterables.any((Iterable)customFieldSchemes, this.inScopeByProject(issueContext));
        }
        return Iterables.any((Iterable)customFieldSchemes, (Predicate)Predicates.and(this.inScopeByProject(issueContext), this.inScopeByIssueType(issueContext)));
    }

    private Predicate<FieldConfigScheme> inScopeByProject(final IssueContext issueContext) {
        return new Predicate<FieldConfigScheme>(){

            public boolean apply(@Nullable FieldConfigScheme fieldScheme) {
                if (fieldScheme == null) {
                    return true;
                }
                List associatedProjectIds = fieldScheme.getAssociatedProjectIds();
                return associatedProjectIds.isEmpty() || associatedProjectIds.contains(issueContext.getProjectId());
            }
        };
    }

    private Predicate<FieldConfigScheme> inScopeByIssueType(final IssueContext issueContext) {
        return new Predicate<FieldConfigScheme>(){

            public boolean apply(@Nullable FieldConfigScheme fieldScheme) {
                if (fieldScheme == null) {
                    return true;
                }
                Map configs = fieldScheme.getConfigs();
                return configs.get(issueContext.getIssueTypeId()) != null || configs.get(null) != null;
            }
        };
    }

    private boolean searchingForAnyProjectAndAnyIssueType(IssueContext issueContext) {
        return issueContext == null || this.searchingForAnyProject(issueContext) && this.searchingForAnyIssueType(issueContext);
    }

    private boolean searchingForAnyProject(IssueContext issueContext) {
        return issueContext.getProjectId() == null;
    }

    private boolean searchingForAnyIssueType(IssueContext issueContext) {
        return issueContext.getIssueTypeId() == null;
    }
}

