/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.config.item.DefaultValueConfigItem;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomFieldParamsUtil;
import com.atlassian.jira.issue.fields.DefaultValueOperations;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import webwork.action.Action;

@Internal
public class DefaultValueOperationsCF<T>
implements DefaultValueOperations<T> {
    private final CustomFieldType<T, ?> customFieldType;

    public DefaultValueOperationsCF(@Nonnull CustomFieldType<T, ?> customFieldType) {
        this.customFieldType = Objects.requireNonNull(customFieldType);
    }

    @Nullable
    public T getDefaultValue(@Nonnull FieldConfig fieldConfig) {
        return (T)this.customFieldType.getDefaultValue(fieldConfig);
    }

    public void setDefaultValue(@Nonnull FieldConfig fieldConfig, @Nullable T value) {
        this.customFieldType.setDefaultValue(fieldConfig, value);
    }

    public void populateDefaults(@Nonnull FieldConfig fieldConfig, @Nonnull Map<String, Object> fieldValuesHolder) {
        T defaultValues = this.getDefaultValue(fieldConfig);
        if (defaultValues != null) {
            CustomFieldParamsImpl paramsFromIssue = new CustomFieldParamsImpl(fieldConfig.getCustomField(), defaultValues);
            paramsFromIssue.transformObjectsToStrings();
            fieldValuesHolder.put(fieldConfig.getConfigurableField().getId(), paramsFromIssue);
        }
    }

    public void validateFromActionParams(@Nonnull FieldConfig config, @Nonnull Map actionParameters, @Nonnull ErrorCollection errorCollection) {
        CustomFieldParams relevantParams = CustomFieldParamsUtil.getRelevantParams(config.getCustomField(), actionParameters);
        this.customFieldType.validateFromParams(relevantParams, errorCollection, config);
    }

    public String getViewHtml(@Nonnull FieldConfig fieldConfig, @Nullable FieldLayoutItem fieldLayoutItem) {
        return this.customFieldType.getDescriptor().getDefaultViewHtml(fieldConfig, fieldLayoutItem);
    }

    public String getEditHtml(@Nonnull FieldConfig config, @Nonnull Map customFieldValuesHolder, Action action, Map displayParameters, FieldLayoutItem fieldLayoutItem) {
        MutableIssue dummyIssue = this.getDummyIssue(config);
        return this.customFieldType.getDescriptor().getEditDefaultHtml(config, customFieldValuesHolder, (Issue)dummyIssue, action, displayParameters, fieldLayoutItem);
    }

    public boolean isSupport() {
        return this.customFieldType.getConfigurationItemTypes().stream().anyMatch(configItemType -> configItemType instanceof DefaultValueConfigItem);
    }

    private MutableIssue getDummyIssue(FieldConfig fieldConfig) {
        MutableIssue dummyIssue = ComponentAccessor.getIssueFactory().getIssue();
        FieldConfigScheme fieldConfigScheme = ComponentAccessor.getFieldConfigSchemeManager().getConfigSchemeForFieldConfig(fieldConfig);
        if (fieldConfigScheme != null) {
            Collection associatedIssueTypes;
            List associatedProjects = fieldConfigScheme.getAssociatedProjectObjects();
            if (associatedProjects != null && associatedProjects.size() == 1) {
                dummyIssue.setProjectObject((Project)associatedProjects.iterator().next());
            }
            if ((associatedIssueTypes = fieldConfigScheme.getAssociatedIssueTypes()) != null && associatedIssueTypes.size() == 1) {
                dummyIssue.setIssueTypeObject((IssueType)associatedIssueTypes.iterator().next());
            }
        }
        return dummyIssue;
    }
}

