/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.ColumnViewDateTimeHelper;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.parameters.lucene.sort.UserHistoryFieldComparatorSource;
import com.atlassian.jira.issue.statistics.DateFieldSorter;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.query.order.SortOrder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.FieldComparatorSource;

public class LastViewedSystemField
extends NavigableFieldImpl
implements DateField,
RestAwareField,
ExportableSystemField {
    private final ColumnViewDateTimeHelper columnViewDateTimeHelper;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final UserIssueHistoryManager historyManager;
    public static final SortOrder DEFAULT_SORT_ORDER = SortOrder.DESC;

    public LastViewedSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, ColumnViewDateTimeHelper columnViewDateTimeHelper, DateTimeFormatterFactory dateTimeFormatterFactory, UserIssueHistoryManager historyManager) {
        super("lastViewed", "issue.field.lastviewed", "issue.column.heading.lastviewed", DEFAULT_SORT_ORDER.name(), templatingEngine, applicationProperties, authenticationContext);
        this.columnViewDateTimeHelper = columnViewDateTimeHelper;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.historyManager = historyManager;
    }

    @Override
    public FieldComparatorSource getSortComparatorSource() {
        List fullHistory = this.historyManager.getFullIssueHistoryWithoutPermissionChecks(this.authenticationContext.getUser());
        return new UserHistoryFieldComparatorSource(fullHistory);
    }

    public LuceneFieldSorter getSorter() {
        return DateFieldSorter.ISSUE_LAST_VIEWED_DATE_STATSMAPPER;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Timestamp date = this.getTimestampForIssue(issue.getId());
        if (displayParams.containsKey("excel_view")) {
            return this.columnViewDateTimeHelper.render(this, fieldLayoutItem, displayParams, issue, date);
        }
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.formatter().forLoggedInUser();
        MapBuilder builder = MapBuilder.newBuilder();
        if (date != null) {
            this.dateTimeFormatterFactory.formatter().forLoggedInUser();
            builder.add((Object)"title", (Object)dateTimeFormatter.withStyle(DateTimeStyle.COMPLETE).format((Date)date));
            builder.add((Object)"iso8601", (Object)dateTimeFormatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format((Date)date));
            builder.add((Object)"value", (Object)dateTimeFormatter.withStyle(DateTimeStyle.RELATIVE_ALWAYS_WITH_TIME).format((Date)date));
        }
        return this.renderTemplate("date-columnview.vm", builder.toMap());
    }

    private Timestamp getTimestampForIssue(Long id) {
        Long longTimestampForIssue = this.getLongTimestampForIssue(id);
        return longTimestampForIssue == null ? null : new Timestamp(longTimestampForIssue);
    }

    private Long getLongTimestampForIssue(Long id) {
        List fullHistory = this.historyManager.getFullIssueHistoryWithoutPermissionChecks(this.authenticationContext.getUser());
        for (UserHistoryItem historyItem : fullHistory) {
            if (!id.toString().equals(historyItem.getEntityId())) continue;
            return historyItem.getLastViewed();
        }
        return null;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"datetime", (String)this.getId());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        Timestamp timestamp = this.getTimestampForIssue(issue.getId());
        FieldJsonRepresentation fieldJsonRepresentation = new FieldJsonRepresentation(new JsonData((Object)Dates.asTimeString((Timestamp)timestamp)));
        if (renderedVersionRequired && timestamp != null) {
            fieldJsonRepresentation.setRenderedData(new JsonData((Object)this.dateTimeFormatterFactory.formatter().forLoggedInUser().format((Date)timestamp)));
        }
        return fieldJsonRepresentation;
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        Timestamp timestamp = this.getTimestampForIssue(issue.getId());
        String formattedDate = this.dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.COMPLETE).format((Date)timestamp);
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), (String)formattedDate);
    }
}

