/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.manager;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.auditing.handlers.CustomFieldContextHandler;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.StacktraceParser;
import com.atlassian.jira.issue.fields.config.manager.UpdatedFieldConfigSchemeContextsEvent;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersister;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.NameComparator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.dbc.Null;
import io.atlassian.fugue.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldConfigSchemeManagerImpl
implements FieldConfigSchemeManager {
    static final String UNKNOWN_CALLER = "unknown";
    private static final Logger log = LoggerFactory.getLogger(FieldConfigSchemeManagerImpl.class);
    private final FieldConfigManager configManager;
    private final FieldConfigSchemePersister schemePersister;
    private final FieldConfigContextPersister contextPersister;
    private final CustomFieldContextHandler customFieldContextHandler;
    private final EventPublisher eventPublisher;
    private final StacktraceParser stacktraceParser;

    public FieldConfigSchemeManagerImpl(FieldConfigSchemePersister configSchemePersister, FieldConfigContextPersister contextPersister, FieldConfigManager configManager, CustomFieldContextHandler customFieldContextHandler, EventPublisher eventPublisher) {
        this.schemePersister = configSchemePersister;
        this.contextPersister = contextPersister;
        this.configManager = configManager;
        this.customFieldContextHandler = customFieldContextHandler;
        this.eventPublisher = eventPublisher;
        this.stacktraceParser = StacktraceParser.createStacktraceParserForFieldConfigSchemeManager();
    }

    public void init() {
        this.schemePersister.init();
    }

    public List<FieldConfigScheme> getConfigSchemesForField(ConfigurableField field) {
        return this.schemePersister.getConfigSchemesForCustomField(field);
    }

    public FieldConfigScheme getConfigSchemeForFieldConfig(FieldConfig fieldConfig) {
        Assertions.notNull((String)"fieldConfig", (Object)fieldConfig);
        try {
            return this.schemePersister.getConfigSchemeForFieldConfig(fieldConfig);
        }
        catch (DataAccessException e) {
            return null;
        }
    }

    public FieldConfigScheme getFieldConfigScheme(Long configSchemeId) {
        if (configSchemeId != null) {
            return this.schemePersister.getFieldConfigScheme(configSchemeId);
        }
        return null;
    }

    private FieldConfigScheme createFieldConfigScheme(FieldConfigScheme newConfigScheme, List<JiraContextNode> contexts, ConfigurableField field) {
        FieldConfigScheme configScheme = this.schemePersister.create(newConfigScheme, field);
        if (contexts != null && !contexts.isEmpty()) {
            this.storeAssociatedContexts(configScheme, contexts, field);
        } else {
            log.info("ConfigScheme " + configScheme.getName() + " (" + configScheme.getId() + "). Created with no associated contexts");
        }
        if (this.isCustomField(field)) {
            this.customFieldContextHandler.handleCustomFieldContextAdded(configScheme);
        }
        return configScheme;
    }

    public FieldConfigScheme createFieldConfigScheme(FieldConfigScheme newConfigScheme, List<JiraContextNode> contexts, List<IssueType> issueTypes, ConfigurableField field) {
        FieldConfigScheme.Builder builder = new FieldConfigScheme.Builder(newConfigScheme);
        if (field != null && issueTypes != null && !issueTypes.isEmpty()) {
            Map<String, FieldConfig> issueTypesMappings = this.issueTypesToMappings(issueTypes, field);
            builder.setConfigs(issueTypesMappings);
        }
        return this.createFieldConfigScheme(builder.toFieldConfigScheme(), contexts, field);
    }

    public FieldConfigScheme createDefaultScheme(ConfigurableField field, List<JiraContextNode> contexts, List<IssueType> issueTypes) {
        if (field != null && issueTypes != null && !issueTypes.isEmpty()) {
            Map<String, FieldConfig> issueTypesMappings = this.issueTypesToMappings(issueTypes, field);
            FieldConfigScheme defaultScheme = this.schemePersister.createWithDefaultValues(field, issueTypesMappings);
            if (contexts != null && !contexts.isEmpty()) {
                this.storeAssociatedContexts(defaultScheme, contexts, field);
            } else {
                log.info("ConfigScheme " + defaultScheme.getName() + " (" + defaultScheme.getId() + "). Created with no associated contexts");
            }
            return defaultScheme;
        }
        log.info("Incomplete information supplied. Default scheme not created.");
        return null;
    }

    private Map<String, FieldConfig> issueTypesToMappings(List<IssueType> issueTypes, ConfigurableField field) {
        FieldConfig config = this.configManager.createWithDefaultValues(field);
        HashMap<String, FieldConfig> issueTypesMappings = new HashMap<String, FieldConfig>(issueTypes.size());
        for (IssueType issueType : issueTypes) {
            String issueTypeId = issueType == null ? null : issueType.getId();
            issueTypesMappings.put(issueTypeId, config);
        }
        return issueTypesMappings;
    }

    public FieldConfigScheme createDefaultScheme(ConfigurableField field, List<JiraContextNode> contexts) {
        return this.createDefaultScheme(field, contexts, ALL_ISSUE_TYPES);
    }

    public void removeSchemeAssociation(List<JiraContextNode> contexts, ConfigurableField configurableField) {
        this.contextPersister.store(configurableField.getId(), contexts, null);
    }

    public List<Project> getAssociatedProjectObjects(ConfigurableField field) {
        List<FieldConfigScheme> configurations = this.getConfigSchemesForField(field);
        LinkedList projects = new LinkedList();
        if (configurations != null) {
            for (FieldConfigScheme config : configurations) {
                List configProject = config.getAssociatedProjectObjects();
                if (configProject == null) continue;
                projects.addAll(configProject);
            }
            Collections.sort(projects, NameComparator.COMPARATOR);
        }
        return Collections.unmodifiableList(projects);
    }

    public FieldConfigScheme updateFieldConfigScheme(FieldConfigScheme scheme, List<JiraContextNode> contexts, ConfigurableField field) {
        List currentContexts = this.contextPersister.getAllContextsForConfigScheme(scheme);
        Set<JiraContextNode> addedContexts = this.contextsDifference(contexts, currentContexts);
        Set<JiraContextNode> removedContexts = this.contextsDifference(currentContexts, contexts);
        return this.updateFieldConfigScheme(scheme, addedContexts, removedContexts, field);
    }

    public FieldConfigScheme addAssociatedContexts(FieldConfigScheme scheme, Set<JiraContextNode> contextsToBeAdded, ConfigurableField field) {
        return this.updateFieldConfigScheme(scheme, contextsToBeAdded, Collections.emptySet(), field);
    }

    public FieldConfigScheme removeAssociatedContexts(FieldConfigScheme scheme, Set<JiraContextNode> contextsToBeRemoved, ConfigurableField field) {
        return this.updateFieldConfigScheme(scheme, Collections.emptySet(), contextsToBeRemoved, field);
    }

    private FieldConfigScheme updateFieldConfigScheme(FieldConfigScheme newScheme, Set<JiraContextNode> contextsToBeAdded, Set<JiraContextNode> contextsToBeRemoved, ConfigurableField field) {
        Objects.requireNonNull(field);
        Assertions.notNull((String)"newScheme", (Object)newScheme);
        Assertions.notNull((String)"field", (Object)field);
        FieldConfigScheme oldCFValue = this.isCustomField(field) ? this.schemePersister.getFieldConfigScheme(newScheme.getId()) : null;
        FieldConfigScheme configScheme = this.updateFieldConfigScheme(newScheme);
        if (log.isTraceEnabled()) {
            log.trace("Updating FieldConfigScheme context associations. Caller's stacktrace: ", (Throwable)new Exception());
        }
        int initialContextsCount = newScheme == null ? -1 : this.contextPersister.getAllContextsForConfigScheme(newScheme).size();
        int contextsAddedCount = contextsToBeAdded == null ? 0 : contextsToBeAdded.size();
        int contextsRemovedCount = contextsToBeRemoved == null ? 0 : contextsToBeRemoved.size();
        int targetContextsCount = initialContextsCount + contextsAddedCount - contextsRemovedCount;
        this.performContextAssociationUpdateOperations(field, configScheme, contextsToBeAdded, contextsToBeRemoved);
        if (this.isCustomField(field)) {
            this.customFieldContextHandler.handleCustomFieldContextUpdated(oldCFValue, configScheme);
        }
        int finalContextsCount = this.contextPersister.getAllContextsForConfigScheme(newScheme).size();
        String executionPathIdentifier = this.stacktraceParser.checkForKnownCallers(new Exception().getStackTrace());
        log.trace("Updated FieldConfigScheme context associations. Initial count: {}. Intended count: {}. Final count: {}. Originating caller: {}", new Object[]{initialContextsCount, targetContextsCount, finalContextsCount, executionPathIdentifier});
        if (targetContextsCount != finalContextsCount) {
            log.warn("Error updating FieldConfigScheme context associations. The intended and final context counts don't match. Initial count: {}. Intended count: {}. Final count {}.", new Object[]{initialContextsCount, targetContextsCount, finalContextsCount});
            log.warn("Caller's stacktrace: ", (Throwable)new Exception());
        }
        this.eventPublisher.publish((Object)new UpdatedFieldConfigSchemeContextsEvent(executionPathIdentifier, initialContextsCount, targetContextsCount, finalContextsCount));
        return configScheme;
    }

    public FieldConfigScheme updateFieldConfigScheme(FieldConfigScheme scheme) {
        return this.schemePersister.update(scheme);
    }

    public void removeFieldConfigScheme(Long fieldConfigSchemeId) {
        FieldConfigScheme fieldConfigScheme = this.getFieldConfigScheme(fieldConfigSchemeId);
        this.contextPersister.removeContextsForConfigScheme(fieldConfigScheme);
        this.configManager.removeConfigsForConfigScheme(fieldConfigSchemeId);
        this.schemePersister.remove(fieldConfigSchemeId);
        if (this.isCustomField(fieldConfigScheme.getField())) {
            this.customFieldContextHandler.handleCustomFieldContextDeleted(fieldConfigScheme);
        }
    }

    public void removeInvalidFieldConfigSchemesForIssueType(IssueType issueType) {
        Collection fieldConfigSchemes = this.getInvalidFieldConfigSchemesForIssueTypeRemoval(issueType);
        for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
            this.removeFieldConfigScheme(fieldConfigScheme.getId());
        }
        this.schemePersister.removeByIssueType(issueType);
    }

    public void removeInvalidFieldConfigSchemesForCustomField(String customFieldId) {
        List<Long> schemeIds = this.schemePersister.getConfigSchemeIdsForCustomFieldId(customFieldId);
        for (Long schemeId : schemeIds) {
            this.removeFieldConfigScheme(schemeId);
        }
    }

    public Collection getInvalidFieldConfigSchemesForIssueTypeRemoval(IssueType issueType) {
        Null.not("issueType", issueType);
        return this.schemePersister.getInvalidFieldConfigSchemeAfterIssueTypeRemoval(issueType);
    }

    public boolean isRelevantForIssueContext(IssueContext issueContext, ConfigurableField field) {
        return this.contextPersister.getRelevantConfigSchemeId(issueContext, field.getId()) != null;
    }

    public FieldConfig getRelevantConfig(IssueContext issueContext, ConfigurableField field) {
        FieldConfigScheme scheme = this.getRelevantConfigScheme(issueContext.getProjectId(), field.getId());
        if (scheme != null) {
            Map configs = scheme.getConfigs();
            if (configs != null) {
                String issueTypeId;
                FieldConfig configForAnyIssueType = (FieldConfig)configs.get(null);
                if (configForAnyIssueType != null) {
                    return configForAnyIssueType;
                }
                IssueType issueType = issueContext.getIssueTypeObject();
                String string = issueTypeId = issueType == null ? null : issueType.getId();
                if (issueTypeId == null && !configs.isEmpty()) {
                    return (FieldConfig)Iterables.first(configs.values()).get();
                }
                FieldConfig config = (FieldConfig)configs.get(issueTypeId);
                if (config != null) {
                    return config;
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    public FieldConfigScheme getRelevantConfigScheme(IssueContext issueContext, ConfigurableField field) {
        return this.getRelevantConfigScheme(issueContext.getProjectId(), field.getId());
    }

    @Nullable
    public FieldConfigScheme getRelevantConfigScheme(Project project, ConfigurableField field) {
        Long projectId = project == null ? null : project.getId();
        return this.getRelevantConfigScheme(projectId, field.getId());
    }

    private FieldConfigScheme getRelevantConfigScheme(Long projectId, String fieldId) {
        Long schemeId = this.contextPersister.getRelevantConfigSchemeId(projectId, fieldId);
        return this.schemePersister.getFieldConfigScheme(schemeId);
    }

    private void performContextAssociationUpdateOperations(ConfigurableField field, FieldConfigScheme configScheme, Set<JiraContextNode> addedContexts, Set<JiraContextNode> removedContexts) {
        if (removedContexts != null && !removedContexts.isEmpty()) {
            this.contextPersister.removeContexts(field.getId(), removedContexts);
        }
        this.storeAssociatedContexts(configScheme, addedContexts, field);
    }

    private void storeAssociatedContexts(FieldConfigScheme config, Collection<JiraContextNode> contexts, ConfigurableField field) {
        this.contextPersister.store(field.getId(), contexts, config);
    }

    private boolean isCustomField(ConfigurableField field) {
        return field != null && CustomField.class.isAssignableFrom(field.getClass());
    }

    private Set<JiraContextNode> contextsDifference(Collection<JiraContextNode> contexts1, Collection<JiraContextNode> contexts2) {
        HashSet<JiraContextNode> result = new HashSet<JiraContextNode>(contexts1);
        result.removeAll(contexts2);
        return result;
    }
}

