/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field.enterprise;

import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class ImmutableFieldConfigurationScheme
implements FieldConfigurationScheme {
    private final Map<String, Long> issueTypeToFieldLayoutMap;
    private final Set<Long> allFieldLayouts;
    private final Set<Long> allFieldLayoutsWithoutDefault;
    private final Long id;
    private final String name;
    private final String description;

    public ImmutableFieldConfigurationScheme(GenericValue genericValue, Collection<GenericValue> fieldLayoutSchemeEntityGVs) {
        this.id = genericValue.getLong("id");
        this.name = genericValue.getString("name");
        this.description = genericValue.getString("description");
        HashMap<String, Long> tempMap = new HashMap<String, Long>();
        HashSet<Long> tempAllWithoutDefault = new HashSet<Long>();
        for (GenericValue fieldLayoutSchemeEntityGV : fieldLayoutSchemeEntityGVs) {
            String issueTypeId = fieldLayoutSchemeEntityGV.getString("issuetype");
            Long fieldLayoutId = fieldLayoutSchemeEntityGV.getLong("fieldlayout");
            tempMap.put(issueTypeId, fieldLayoutId);
            if (issueTypeId == null) continue;
            tempAllWithoutDefault.add(fieldLayoutId);
        }
        this.issueTypeToFieldLayoutMap = Collections.unmodifiableMap(tempMap);
        this.allFieldLayouts = Collections.unmodifiableSet(new HashSet<Long>(this.issueTypeToFieldLayoutMap.values()));
        this.allFieldLayoutsWithoutDefault = Collections.unmodifiableSet(tempAllWithoutDefault);
    }

    public Long getFieldLayoutId(String issueTypeId) {
        if (this.issueTypeToFieldLayoutMap.containsKey(issueTypeId)) {
            return this.issueTypeToFieldLayoutMap.get(issueTypeId);
        }
        return this.issueTypeToFieldLayoutMap.get(null);
    }

    public Set<Long> getAllFieldLayoutIds(Collection<String> allIssueTypeIds) {
        if (this.issueTypeToFieldLayoutMap.keySet().containsAll(allIssueTypeIds)) {
            return this.allFieldLayoutsWithoutDefault;
        }
        return this.allFieldLayouts;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

