/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ExternalLinkInNewWindow;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.renderer.RendererConfiguration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ServletActionContext;

public class JiraRendererConfiguration
implements RendererConfiguration {
    private ApplicationProperties applicationProperties;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final JiraAuthenticationContext authContext;
    private final ExternalLinkInNewWindow externalLinkInNewWindow;

    public JiraRendererConfiguration(ApplicationProperties applicationProperties, VelocityRequestContextFactory velocityRequestContextFactory, JiraAuthenticationContext authContext, ExternalLinkInNewWindow externalLinkInNewWindow) {
        this.applicationProperties = applicationProperties;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.authContext = authContext;
        this.externalLinkInNewWindow = externalLinkInNewWindow;
    }

    public String getWebAppContextPath() {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            return request.getContextPath();
        }
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        if (StringUtils.isWhitespace((CharSequence)baseUrl)) {
            baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        }
        return StringUtils.isBlank((CharSequence)baseUrl) ? this.applicationProperties.getString("jira.baseurl") : baseUrl;
    }

    public boolean isNofollowExternalLinks() {
        return true;
    }

    public boolean isAllowCamelCase() {
        return false;
    }

    public String getCharacterEncoding() {
        return this.applicationProperties.getEncoding();
    }

    public boolean isOpenExternalLinksInNewWindow() {
        return this.externalLinkInNewWindow.isEnabled(this.authContext.getLoggedInUser());
    }

    private HttpServletRequest getRequest() {
        HttpServletRequest request = null;
        try {
            request = ServletActionContext.getRequest();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return request;
    }
}

