/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.rest.json.beans.SuggestionBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.BaseUrl;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SuggestionBeanFactory {
    private final AvatarService avatarService;
    private final BaseUrl baseUrl;

    public SuggestionBeanFactory(AvatarService avatarService, BaseUrl baseUrl) {
        this.avatarService = avatarService;
        this.baseUrl = baseUrl;
    }

    public Collection<SuggestionBean> projectSuggestions(Collection<Project> projects, Optional<Long> selectedProjectId) {
        ArrayList result = Lists.newArrayListWithCapacity((int)projects.size());
        for (Project project : projects) {
            boolean isSelected = selectedProjectId.isPresent() && project.getId().equals(selectedProjectId.get());
            result.add(this.projectSuggestion(project, isSelected));
        }
        return result;
    }

    public Collection<SuggestionBean> optionSuggestions(Collection<Option> options, Optional<String> selectedOptionId) {
        ArrayList result = Lists.newArrayListWithCapacity((int)options.size());
        for (Option option : options) {
            boolean isSelected = selectedOptionId.isPresent() && option.getId().equals(selectedOptionId.get());
            result.add(this.optionSuggestion(option, isSelected));
        }
        return result;
    }

    private SuggestionBean optionSuggestion(Option option, boolean isSelected) {
        String iconUri = this.toIconURI(option.getImagePath());
        return new SuggestionBean(option.getName(), option.getId(), iconUri, isSelected);
    }

    private SuggestionBean projectSuggestion(Project project, boolean isSelected) {
        String label = project.getName() + " (" + project.getKey() + ")";
        String value = project.getId().toString();
        String icon = this.avatarService.getProjectAvatarAbsoluteURL(project, Avatar.Size.SMALL).toString();
        return new SuggestionBean(label, value, icon, isSelected);
    }

    @Nullable
    private String toIconURI(@Nullable String imagePath) {
        if (imagePath == null) {
            return null;
        }
        try {
            String relativeImagePath = StringUtils.stripStart((String)imagePath.trim(), (String)"/");
            URI imageURI = new URI(relativeImagePath);
            return this.baseUrl.getBaseUri().resolve(imageURI).toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

