/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.field.screen.AbstractFieldScreenLayoutItemEvent;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenStore;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class CachingFieldScreenStore
implements FieldScreenStore {
    private static final Logger log = LoggerFactory.getLogger(CachingFieldScreenStore.class);
    private final FieldScreenStore decoratedStore;
    private final Cache<Long, Optional<FieldScreen>> fieldScreenCache;
    private final CachedReference<List<Long>> allScreensCache;

    public CachingFieldScreenStore(FieldScreenStore decoratedStore, CacheManager cacheManager) {
        this.decoratedStore = decoratedStore;
        this.allScreensCache = cacheManager.getCachedReference(this.getClass().getName() + ".allScreensCache", decoratedStore::getFieldScreenIds);
        this.fieldScreenCache = cacheManager.getCache(this.getClass().getName() + ".fieldScreenCache", id -> Optional.ofNullable(decoratedStore.getFieldScreen((Long)id)), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @Override
    public void setFieldScreenManager(FieldScreenManager fieldScreenManager) {
        this.decoratedStore.setFieldScreenManager(fieldScreenManager);
    }

    @Override
    @Nullable
    public FieldScreen getFieldScreen(Long id) {
        return ((Optional)this.fieldScreenCache.get((Object)id)).orElse(null);
    }

    @Override
    public List<Long> getFieldScreenIds() {
        return (List)this.allScreensCache.get();
    }

    @Override
    public List<FieldScreen> getFieldScreens() {
        return (List)this.getFieldScreenIds().stream().map(this::getFieldScreen).filter(Objects::nonNull).sorted(Comparator.comparing(FieldScreen::getName)).collect(CollectorsUtil.toImmutableList());
    }

    @Override
    public void createFieldScreen(FieldScreen fieldScreen) {
        try {
            this.decoratedStore.createFieldScreen(fieldScreen);
        }
        finally {
            this.allScreensCache.reset();
            this.fieldScreenCache.remove((Object)fieldScreen.getId());
        }
    }

    @Override
    public void removeFieldScreen(Long id) {
        try {
            this.decoratedStore.removeFieldScreen(id);
        }
        finally {
            this.allScreensCache.reset();
            this.fieldScreenCache.remove((Object)id);
        }
    }

    @Override
    public void updateFieldScreen(FieldScreen fieldScreen) {
        try {
            this.decoratedStore.updateFieldScreen(fieldScreen);
        }
        finally {
            this.fieldScreenCache.remove((Object)fieldScreen.getId());
        }
    }

    @Override
    public void createFieldScreenTab(FieldScreenTab fieldScreenTab) {
        try {
            this.decoratedStore.createFieldScreenTab(fieldScreenTab);
        }
        finally {
            if (fieldScreenTab != null && fieldScreenTab.getFieldScreen() != null) {
                this.fieldScreenCache.remove((Object)fieldScreenTab.getFieldScreen().getId());
            }
        }
    }

    @Override
    public void updateFieldScreenTab(FieldScreenTab fieldScreenTab) {
        try {
            this.decoratedStore.updateFieldScreenTab(fieldScreenTab);
        }
        finally {
            if (fieldScreenTab != null && fieldScreenTab.getFieldScreen() != null) {
                this.fieldScreenCache.remove((Object)fieldScreenTab.getFieldScreen().getId());
            }
        }
    }

    @Override
    public List<FieldScreenTab> getFieldScreenTabs(FieldScreen fieldScreen) {
        return this.decoratedStore.getFieldScreenTabs(fieldScreen);
    }

    @Override
    public void updateFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.decoratedStore.updateFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public void removeFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.decoratedStore.removeFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public void removeFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        this.decoratedStore.removeFieldScreenLayoutItems(fieldScreenTab);
    }

    @Override
    public List<FieldScreenLayoutItem> getFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        return this.decoratedStore.getFieldScreenLayoutItems(fieldScreenTab);
    }

    @Override
    public void refresh() {
        this.allScreensCache.reset();
        this.fieldScreenCache.removeAll();
        if (log.isTraceEnabled()) {
            log.trace("Called refresh()", new Throwable());
        }
    }

    @EventListener
    public void onFieldScreenLayoutChange(AbstractFieldScreenLayoutItemEvent event) {
        this.fieldScreenCache.remove((Object)event.getFieldScreenId());
    }

    @Override
    public void createFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.decoratedStore.createFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public FieldScreenLayoutItem buildNewFieldScreenLayoutItem(GenericValue genericValue) {
        return this.decoratedStore.buildNewFieldScreenLayoutItem(genericValue);
    }

    @Override
    public void removeFieldScreenTabs(FieldScreen fieldScreen) {
        this.decoratedStore.removeFieldScreenTabs(fieldScreen);
        this.fieldScreenCache.remove((Object)fieldScreen.getId());
    }

    @Override
    public void removeFieldScreenTab(Long id) {
        FieldScreenTab tab = this.getFieldScreenTab(id);
        try {
            this.decoratedStore.removeFieldScreenTab(id);
        }
        finally {
            if (tab != null && tab.getFieldScreen() != null) {
                this.fieldScreenCache.remove((Object)tab.getFieldScreen().getId());
            }
        }
    }

    @Override
    public FieldScreenTab getFieldScreenTab(Long tabId) {
        return this.decoratedStore.getFieldScreenTab(tabId);
    }

    @Override
    public boolean screenNameExists(String name) {
        return this.decoratedStore.screenNameExists(name);
    }
}

