/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.AbstractFieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import org.ofbiz.core.entity.GenericValue;

public class FieldScreenLayoutItemImpl
extends AbstractFieldScreenLayoutItem {
    private Long id;

    public FieldScreenLayoutItemImpl(FieldScreenManager fieldScreenManager, FieldManager fieldManager) {
        this(fieldScreenManager, fieldManager, null);
    }

    public FieldScreenLayoutItemImpl(FieldScreenManager fieldScreenManager, FieldManager fieldManager, GenericValue genericValue) {
        super(fieldScreenManager, fieldManager);
        this.setGenericValue(genericValue);
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            this.id = this.getGenericValue().getLong("id");
            this.fieldId = this.getGenericValue().getString("fieldidentifier");
            if (this.getGenericValue().getLong("sequence") != null) {
                this.position = this.getGenericValue().getLong("sequence").intValue();
            }
        }
        this.setModified(false);
    }

    public Long getId() {
        return this.id;
    }

    public void setPosition(int position) {
        this.position = position;
        this.updateGV("sequence", position);
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
        this.updateGV("fieldidentifier", fieldId);
    }

    public void setFieldScreenTab(FieldScreenTab fieldScreenTab) {
        this.fieldScreenTab = fieldScreenTab;
        if (fieldScreenTab == null) {
            this.updateGV("fieldscreentab", null);
        } else {
            this.updateGV("fieldscreentab", fieldScreenTab.getId());
        }
    }

    public void store() {
        if (this.isModified()) {
            if (this.id == null) {
                this.getFieldScreenManager().createFieldScreenLayoutItem((FieldScreenLayoutItem)this);
            } else {
                this.getFieldScreenManager().updateFieldScreenLayoutItem((FieldScreenLayoutItem)this);
                this.setModified(false);
            }
        }
    }

    public void remove() {
        this.getFieldScreenManager().removeFieldScreenLayoutItem((FieldScreenLayoutItem)this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldScreenLayoutItem)) {
            return false;
        }
        FieldScreenLayoutItem fieldScreenLayoutItem = (FieldScreenLayoutItem)o;
        if (this.id != null ? !this.id.equals(fieldScreenLayoutItem.getId()) : fieldScreenLayoutItem.getId() != null) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 29 * result + super.hashCode();
        return result;
    }
}

