/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.issuetype;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.comparator.IssueTypeKeyComparator;
import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import org.ofbiz.core.entity.GenericValue;

public class IssueTypeScreenSchemeEntityImpl
extends AbstractGVBean
implements IssueTypeScreenSchemeEntity {
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final ConstantsManager constantsManager;
    private final IssueTypeKeyComparator comparator;
    private Long id;
    private String issueTypeId;
    private Long fieldScreenSchemeId;
    private IssueTypeScreenScheme issueTypeScreenScheme;

    public IssueTypeScreenSchemeEntityImpl(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldScreenSchemeManager fieldScreenSchemeManager, ConstantsManager constantsManager) {
        this(issueTypeScreenSchemeManager, (GenericValue)null, fieldScreenSchemeManager, constantsManager);
    }

    public IssueTypeScreenSchemeEntityImpl(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, GenericValue genericValue, FieldScreenSchemeManager fieldScreenSchemeManager, ConstantsManager constantsManager) {
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.constantsManager = constantsManager;
        this.comparator = new IssueTypeKeyComparator(constantsManager);
        this.setGenericValue(genericValue);
    }

    public IssueTypeScreenSchemeEntityImpl(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity, FieldScreenSchemeManager fieldScreenSchemeManager, ConstantsManager constantsManager) {
        this(issueTypeScreenSchemeManager, (GenericValue)null, fieldScreenSchemeManager, constantsManager);
        this.setIssueTypeId(issueTypeScreenSchemeEntity.getIssueTypeId());
        this.setFieldScreenScheme(issueTypeScreenSchemeEntity.getFieldScreenScheme());
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            this.id = this.getGenericValue().getLong("id");
        }
        this.setModified(false);
    }

    public Long getId() {
        return this.id;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public IssueType getIssueTypeObject() {
        return this.getIssueType();
    }

    public IssueType getIssueType() {
        if (this.getIssueTypeId() != null) {
            return this.constantsManager.getIssueType(this.getIssueTypeId());
        }
        return null;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
        this.updateGV("issuetype", issueTypeId);
    }

    public FieldScreenScheme getFieldScreenScheme() {
        return this.fieldScreenSchemeManager.getFieldScreenScheme(this.fieldScreenSchemeId);
    }

    public void setFieldScreenScheme(FieldScreenScheme fieldScreenScheme) {
        this.fieldScreenSchemeId = fieldScreenScheme != null ? fieldScreenScheme.getId() : null;
        this.updateGV("fieldscreenscheme", this.fieldScreenSchemeId);
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme() {
        return this.issueTypeScreenScheme;
    }

    public void setIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        this.issueTypeScreenScheme = issueTypeScreenScheme;
        if (issueTypeScreenScheme != null) {
            this.updateGV("scheme", issueTypeScreenScheme.getId());
        } else {
            this.updateGV("scheme", null);
        }
    }

    public Long getFieldScreenSchemeId() {
        return this.fieldScreenSchemeId;
    }

    public void store() {
        if (this.isModified()) {
            if (this.getGenericValue() == null) {
                this.issueTypeScreenSchemeManager.createIssueTypeScreenSchemeEntity((IssueTypeScreenSchemeEntity)this);
            } else {
                this.issueTypeScreenSchemeManager.updateIssueTypeScreenSchemeEntity((IssueTypeScreenSchemeEntity)this);
                this.setModified(false);
            }
        }
    }

    public void remove() {
        if (this.getGenericValue() != null) {
            this.issueTypeScreenSchemeManager.removeIssueTypeScreenSchemeEntity((IssueTypeScreenSchemeEntity)this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IssueTypeScreenSchemeEntityImpl)) {
            return false;
        }
        IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = (IssueTypeScreenSchemeEntity)o;
        if (this.fieldScreenSchemeId != null ? !this.fieldScreenSchemeId.equals(issueTypeScreenSchemeEntity.getFieldScreenSchemeId()) : issueTypeScreenSchemeEntity.getFieldScreenSchemeId() != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(issueTypeScreenSchemeEntity.getId()) : issueTypeScreenSchemeEntity.getId() != null) {
            return false;
        }
        if (this.issueTypeId != null ? !this.issueTypeId.equals(issueTypeScreenSchemeEntity.getIssueTypeId()) : issueTypeScreenSchemeEntity.getIssueTypeId() != null) {
            return false;
        }
        return !(this.issueTypeScreenScheme != null ? !this.issueTypeScreenScheme.equals(issueTypeScreenSchemeEntity.getIssueTypeScreenScheme()) : issueTypeScreenSchemeEntity.getIssueTypeScreenScheme() != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 29 * result + (this.issueTypeId != null ? this.issueTypeId.hashCode() : 0);
        result = 29 * result + (this.fieldScreenSchemeId != null ? this.fieldScreenSchemeId.hashCode() : 0);
        result = 29 * result + (this.issueTypeScreenScheme != null ? this.issueTypeScreenScheme.hashCode() : 0);
        return result;
    }

    public int compareTo(IssueTypeScreenSchemeEntity other) {
        return this.comparator.compare(this.getIssueTypeId(), other.getIssueTypeId());
    }
}

