/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.usage;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageDAO;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageEnabledCheck;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageLastValueFlushEvent;
import com.atlassian.jira.util.concurrent.ScheduledExecutorServiceUtils;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldUsageDataWriter {
    public static final String SYSTEM_PROPERTY_LAST_USAGE_FLUSH_PERIOD_MINUTES = "com.atlassian.jira.issue.fields.usage.date.flush.period.minutes";
    private static final Logger log = LoggerFactory.getLogger(CustomFieldUsageDataWriter.class);
    private final Runnable dbWriter = JiraThreadLocalUtils.wrap(this::flushUsageDataToDB);
    private final ScheduledExecutorService scheduler;
    private final CustomFieldUsageDAO usageDAO;
    private final CustomFieldManager customFieldManager;
    private final EventPublisher eventPublisher;
    private final Map<Long, Timestamp> bufferedCustomFieldUpdates = new ConcurrentHashMap<Long, Timestamp>();
    private static final Long DEFAULT_FLUSH_PERIOD = 60L;
    private final Long flushPeriodMinutes;
    private final CustomFieldUsageEnabledCheck customFieldUsageEnabledCheck;

    public CustomFieldUsageDataWriter(CustomFieldUsageDAO usageDAO, CustomFieldManager customFieldManager, EventPublisher eventPublisher, CustomFieldUsageEnabledCheck customFieldUsageEnabledCheck) {
        this.usageDAO = usageDAO;
        this.customFieldManager = customFieldManager;
        this.customFieldUsageEnabledCheck = customFieldUsageEnabledCheck;
        this.flushPeriodMinutes = this.getFromProperties();
        this.eventPublisher = eventPublisher;
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CustomFieldUsageDataWriter:thread-%d").build());
        eventPublisher.register((Object)this);
    }

    private Long getFromProperties() {
        Long propertiesValue = JiraSystemProperties.getInstance().getLong(SYSTEM_PROPERTY_LAST_USAGE_FLUSH_PERIOD_MINUTES, DEFAULT_FLUSH_PERIOD);
        if (propertiesValue > 0L) {
            return propertiesValue;
        }
        log.warn("Detected incorrect value of {}, using default {}", (Object)SYSTEM_PROPERTY_LAST_USAGE_FLUSH_PERIOD_MINUTES, (Object)DEFAULT_FLUSH_PERIOD);
        return DEFAULT_FLUSH_PERIOD;
    }

    @EventListener
    public void onPluginFrameworkStartedEvent(PluginFrameworkStartedEvent event) {
        log.info("Starting periodic Custom Field usage info writer to run every {} minute(s). ", (Object)this.flushPeriodMinutes);
        ScheduledExecutorServiceUtils.scheduleWithVariableDelay(this.scheduler, this.dbWriter, Duration.ofMinutes(this.flushPeriodMinutes), Duration.ofMinutes(this.flushPeriodMinutes));
    }

    @EventListener
    public void onPluginFrameworkShutdownEvent(PluginFrameworkShutdownEvent event) {
        this.scheduler.shutdownNow();
    }

    public synchronized void flushUsageDataToDB() {
        long startDate = System.currentTimeMillis();
        if (!this.customFieldUsageEnabledCheck.isCustomFieldUsageIdentificationEnabled()) {
            if (this.bufferedCustomFieldUpdates.size() > 0) {
                this.bufferedCustomFieldUpdates.clear();
            }
            if (!this.customFieldUsageEnabledCheck.isEnabledForLicense()) {
                log.trace("Tracking 'Last value update' of custom fields is disabled for current license");
            } else {
                log.warn("Tracking 'Last value update' of custom fields is disabled by a feature flag: {}", (Object)JiraFeatureFlagRegistrar.CUSTOMFIELDS_IDENTIFICATION);
            }
            return;
        }
        if (this.bufferedCustomFieldUpdates.size() <= 0) {
            this.eventPublisher.publish((Object)new CustomFieldUsageLastValueFlushEvent(startDate, System.currentTimeMillis(), 0, true));
            log.trace("No Custom Field values update info to write to DB, skipping...");
            return;
        }
        ImmutableMap tempMap = ImmutableMap.copyOf(this.bufferedCustomFieldUpdates);
        try {
            Timestamp updateDate = Timestamp.from(Instant.now());
            log.debug("Saving info about {} Custom Fields having value update on {}", (Object)tempMap.size(), (Object)updateDate);
            Long updated = this.usageDAO.updateCustomFieldsWithLatestValueUpdate(tempMap.keySet(), updateDate);
            log.debug("Saved info about {}/{} Custom Fields having value update on {}", new Object[]{updated, tempMap.size(), updateDate});
            tempMap.forEach(this.bufferedCustomFieldUpdates::remove);
            this.customFieldManager.clear();
            this.eventPublisher.publish((Object)new CustomFieldUsageLastValueFlushEvent(startDate, System.currentTimeMillis(), tempMap.size(), true));
        }
        catch (Throwable t) {
            this.eventPublisher.publish((Object)new CustomFieldUsageLastValueFlushEvent(startDate, System.currentTimeMillis(), tempMap.size(), false));
            log.error("Error when trying to write buffered Custom Field values update info to DB. Number of Custom Fields with unsaved buffered write info {}. Will retry in {} minute(s)", new Object[]{tempMap.size(), this.flushPeriodMinutes, t});
        }
    }

    public void reportCustomFieldUpdates(Map<Long, Timestamp> customFields) {
        this.bufferedCustomFieldUpdates.putAll(customFields);
    }

    public void reportCustomFieldUpdates(Set<Long> customFields, Timestamp timestamp) {
        this.reportCustomFieldUpdates(customFields.stream().collect(Collectors.toMap(Function.identity(), v -> timestamp)));
    }
}

