/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.usage;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageDataService;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageEnabledCheck;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageIdentificationDisabledException;
import com.atlassian.jira.scheduler.cron.SimpleToCronTriggerConverter;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldUsageRecalculationJob
implements JobRunner,
Startable {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldUsageRecalculationJob.class);
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)CustomFieldUsageRecalculationJob.class.getName());
    static final JobId JOB_ID = JobId.of((String)CustomFieldUsageRecalculationJob.class.getName());
    private static final LocalTime DEFAULT_CALCULATE_USAGE_TIME_OF_DAY = LocalTime.of(3, 0);
    public static final String SYSTEM_PROPERTY_CALCULATE_USAGE_SCHEDULED_TIME = "com.atlassian.jira.issue.fields.usage.calc.timeofday";
    public static final String LAST_ISSUES_RECALCULATION_DATE_KEY = "com.atlassian.jira.issue.fields.usage.calc.date";
    public static final String MESSAGE_INIT_COMPLETE = String.format("Completed with one-time initial data recalculation, triggered by %s set to true", "com.atlassian.jira.issue.fields.usage.init.required");
    public static final String MESSAGE_FAILED_DUE_TO_LOST_LOCK = String.format("Custom field 'Issues' and 'Last value update' calculation process lost the lock %s it already owned, aborting...", CustomFieldUsageDataService.CF_USAGE_CLUSTER_LOCK_NAME);
    private final CustomFieldUsageDataService customFieldUsageDataService;
    private final SchedulerService schedulerService;
    private final ClusterLockService clusterLockService;
    private final CustomFieldUsageEnabledCheck customFieldUsageEnabledCheck;
    private final ApplicationProperties applicationProperties;

    public CustomFieldUsageRecalculationJob(CustomFieldUsageDataService customFieldUsageDataService, SchedulerService schedulerService, CustomFieldUsageEnabledCheck customFieldUsageEnabledCheck, ApplicationProperties applicationProperties, ClusterLockService clusterLockService) {
        this.customFieldUsageDataService = customFieldUsageDataService;
        this.schedulerService = schedulerService;
        this.customFieldUsageEnabledCheck = customFieldUsageEnabledCheck;
        this.applicationProperties = applicationProperties;
        this.clusterLockService = clusterLockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        if (this.customFieldUsageEnabledCheck.isCustomFieldUsageIdentificationEnabled()) {
            ClusterLock clusterLock = this.clusterLockService.getLockForName(CustomFieldUsageDataService.CF_USAGE_CLUSTER_LOCK_NAME);
            if (!clusterLock.tryLock()) {
                return JobRunnerResponse.aborted((String)"Could not obtain cluster lock - custom field usage calculation aborted");
            }
            try {
                this.customFieldUsageDataService.calculateIssuesWithValueData();
                if (this.customFieldUsageEnabledCheck.isCustomFieldUsageIdentificationInitRequired()) {
                    log.info("Starting one-time custom field 'last value update' data initialization because '{}' is set to true", (Object)"com.atlassian.jira.issue.fields.usage.init.required");
                    this.customFieldUsageDataService.writeInitialLastValueUpdateDates();
                    log.info("Completed one-time custom field 'last value update' data initialization. Setting '{}' to false", (Object)"com.atlassian.jira.issue.fields.usage.init.required");
                    this.applicationProperties.setOption("com.atlassian.jira.issue.fields.usage.init.required", false);
                    this.updateLastIssuesRecalculationDateToCurrentDate();
                    JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success((String)MESSAGE_INIT_COMPLETE);
                    return jobRunnerResponse;
                }
                this.updateLastIssuesRecalculationDateToCurrentDate();
                JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success();
                return jobRunnerResponse;
            }
            catch (CustomFieldUsageIdentificationDisabledException e) {
                JobRunnerResponse jobRunnerResponse = JobRunnerResponse.aborted((String)"Custom field 'Issues' and 'Last value update' calculation process was interrupted by feature flag change");
                return jobRunnerResponse;
            }
            catch (CustomFieldUsageDataService.LockNotAcquiredException e) {
                log.error(MESSAGE_FAILED_DUE_TO_LOST_LOCK);
                JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((String)MESSAGE_FAILED_DUE_TO_LOST_LOCK);
                return jobRunnerResponse;
            }
            finally {
                clusterLock.unlock();
            }
        }
        if (!this.customFieldUsageEnabledCheck.isEnabledForLicense()) {
            return JobRunnerResponse.aborted((String)"'Issues with value' calculation is disabled for current license");
        }
        return JobRunnerResponse.aborted((String)("'Issues with value' calculation is disabled by feature flag: " + JiraFeatureFlagRegistrar.CUSTOMFIELDS_IDENTIFICATION));
    }

    private void updateLastIssuesRecalculationDateToCurrentDate() {
        this.applicationProperties.setString(LAST_ISSUES_RECALCULATION_DATE_KEY, String.valueOf(Timestamp.from(Instant.now()).getTime()));
    }

    public void start() {
        try {
            this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
            String cronConfig = this.buildCronConfig();
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forCronExpression((String)cronConfig));
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error("Exception during job registration", (Throwable)e);
        }
    }

    String buildCronConfig() {
        LocalTime timeOfDailyRun = DEFAULT_CALCULATE_USAGE_TIME_OF_DAY;
        String overriddenTimeOfDayString = JiraSystemProperties.getInstance().getProperty(SYSTEM_PROPERTY_CALCULATE_USAGE_SCHEDULED_TIME);
        if (overriddenTimeOfDayString != null && !overriddenTimeOfDayString.isEmpty()) {
            try {
                timeOfDailyRun = LocalTime.parse(overriddenTimeOfDayString, DateTimeFormatter.ofPattern("HH:mm"));
                log.info("Custom field usage daily recalculation time overridden by system property {} to {}", (Object)SYSTEM_PROPERTY_CALCULATE_USAGE_SCHEDULED_TIME, (Object)timeOfDailyRun);
            }
            catch (Exception e) {
                log.warn("Could not parse overriding value of {} - {} as it does not have a valid format 'HH:mm'. Falling back to default {}", new Object[]{SYSTEM_PROPERTY_CALCULATE_USAGE_SCHEDULED_TIME, overriddenTimeOfDayString, DEFAULT_CALCULATE_USAGE_TIME_OF_DAY});
            }
        }
        return new SimpleToCronTriggerConverter().convertToCronString((Date)Date.from((Instant)timeOfDailyRun.atDate((LocalDate)LocalDate.now()).atZone((ZoneId)ZoneId.systemDefault()).toInstant()), (long)Duration.ofHours((long)24L).toMillis()).cronString;
    }
}

