/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.usage;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.event.FieldValuesChangedEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageDataService;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageEnabledCheck;
import com.atlassian.jira.issue.fields.usage.IssueEventProcessingStatsLogger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class FieldValuesChangedListener {
    public static final Long ISSUE_CREATED_ID = EventType.ISSUE_CREATED_ID;
    public static final String SYSTEM_PROPERTY_DETAILED_ISSUE_EVENT_STATS = "com.atlassian.jira.issue.fields.event.detailed.stats.enabled";
    private final CustomFieldUsageDataService customFieldUsageDataService;
    private final CustomFieldUsageEnabledCheck customFieldUsageEnabledCheck;
    private final CustomFieldManager customFieldManager;
    private final IssueEventProcessingStatsLogger totalStatsLogger;
    private final IssueEventProcessingStatsLogger detailedStatsLogger;

    public FieldValuesChangedListener(EventPublisher eventPublisher, CustomFieldUsageDataService customFieldUsageDataService, CustomFieldUsageEnabledCheck customFieldUsageEnabledCheck, CustomFieldManager customFieldManager) {
        this.customFieldUsageEnabledCheck = customFieldUsageEnabledCheck;
        this.customFieldManager = customFieldManager;
        eventPublisher.register((Object)this);
        this.customFieldUsageDataService = customFieldUsageDataService;
        this.totalStatsLogger = IssueEventProcessingStatsLogger.getDefault("[CF-USAGE][UPDATE-TRACKING][OVERVIEW]");
        this.detailedStatsLogger = this.detailedStatsOn() ? IssueEventProcessingStatsLogger.getDefault("[CF-USAGE][UPDATE-TRACKING][DETAILED]") : IssueEventProcessingStatsLogger.getNoOp();
    }

    private boolean detailedStatsOn() {
        return JiraSystemProperties.getInstance().getProperty(SYSTEM_PROPERTY_DETAILED_ISSUE_EVENT_STATS, "false").equalsIgnoreCase("true");
    }

    @EventListener
    public void fieldsChanged(FieldValuesChangedEvent event) {
        if (!this.customFieldUsageEnabledCheck.isCustomFieldUsageIdentificationEnabled()) {
            return;
        }
        this.getTotalStatsLogger().wrap(String.format("total time to process a new field change after issue was %s", event.isNewIssue() ? "created" : "updated"), () -> {
            HashSet customFieldsId = new HashSet();
            Issue issue = event.getIssue();
            Map<String, ModifiedValue> customFieldObjects = event.getModifiedFields();
            for (Map.Entry<String, ModifiedValue> fieldEntry : customFieldObjects.entrySet()) {
                this.detailedStatsLogger.wrap("time to process a single field", () -> {
                    boolean isCF = this.detailedStatsLogger.wrap("time to check if field is a custom field", () -> this.customFieldManager.isCustomField((String)fieldEntry.getKey()));
                    if (isCF) {
                        this.detailedStatsLogger.wrap("time to process single custom field", () -> {
                            CustomField customField = this.detailedStatsLogger.wrap("time to retrieve custom field object", () -> this.customFieldManager.getCustomFieldObject((String)fieldEntry.getKey()));
                            if (this.cfValueChanged(event.isNewIssue(), customField, issue, ((ModifiedValue)fieldEntry.getValue()).getOldValue(), ((ModifiedValue)fieldEntry.getValue()).getNewValue())) {
                                customFieldsId.add(customField.getIdAsLong());
                            }
                        });
                    }
                });
                if (customFieldsId.isEmpty()) continue;
                this.detailedStatsLogger.wrap("time to update custom fields buffer", () -> this.customFieldUsageDataService.updateLastValueUpdateForCustomFields(customFieldsId));
            }
        });
    }

    private boolean cfValueChanged(Boolean isNewIssue, CustomField customField, Issue issue, Object oldValue, Object newValue) {
        return isNewIssue != false ? this.cfInIssueDifferentFromDefault(issue, customField, newValue) : this.cfValuesDifferent(customField, oldValue, newValue);
    }

    private boolean cfInIssueDifferentFromDefault(Issue issue, CustomField cf, Object cfValue) {
        Object defaultValue = this.detailedStatsLogger.wrap("time to retrieve default custom field value", () -> cf.getDefaultValue(issue));
        return this.cfValuesDifferent(cf, cfValue, defaultValue);
    }

    private boolean cfValuesDifferent(CustomField cf, Object cfValue1, Object cfValue2) {
        return this.detailedStatsLogger.wrap("time to compare custom field values", () -> !cf.getCustomFieldType().valuesEqual(this.getNullIfEmptyCollection(cfValue1), this.getNullIfEmptyCollection(cfValue2)));
    }

    private Object getNullIfEmptyCollection(Object value) {
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return null;
        }
        return value;
    }

    private IssueEventProcessingStatsLogger getTotalStatsLogger() {
        return this.customFieldUsageEnabledCheck.isEnabledForLicense() ? this.totalStatsLogger : IssueEventProcessingStatsLogger.getNoOp();
    }
}

