/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.event.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BackgroundIndexListener
extends AbstractIssueEventListener {
    private final Set<Long> updatedIssues = new HashSet<Long>();
    private final Set<Long> deletedIssues = new HashSet<Long>();

    public void issueUpdated(IssueEvent event) {
        this.recordUpdated(event);
    }

    public void issueAssigned(IssueEvent event) {
        this.recordUpdated(event);
    }

    public void issueResolved(IssueEvent event) {
        this.recordUpdated(event);
    }

    public void issueClosed(IssueEvent event) {
        this.recordUpdated(event);
    }

    public void issueCommented(IssueEvent event) {
        this.recordUpdated(event);
    }

    public void issueCommentEdited(IssueEvent event) {
        this.recordUpdated(event);
    }

    public void issueCommentDeleted(IssueEvent event) {
        this.recordUpdated(event);
    }

    public void issueWorklogUpdated(IssueEvent event) {
        this.recordUpdated(event);
    }

    public void issueWorklogDeleted(IssueEvent event) {
        this.recordUpdated(event);
    }

    public void issueReopened(IssueEvent event) {
        this.recordUpdated(event);
    }

    public void issueDeleted(IssueEvent event) {
        this.recordDeleted(event);
    }

    public void issueWorkLogged(IssueEvent event) {
        this.recordUpdated(event);
    }

    public void issueMoved(IssueEvent event) {
        this.recordUpdated(event);
    }

    public Set<Long> getUpdatedIssues() {
        return Collections.unmodifiableSet(this.updatedIssues);
    }

    public Set<Long> getDeletedIssues() {
        return Collections.unmodifiableSet(this.deletedIssues);
    }

    public int getTotalModifications() {
        return this.updatedIssues.size() + this.deletedIssues.size();
    }

    private boolean recordUpdated(IssueEvent event) {
        return this.updatedIssues.add(event.getIssue().getId());
    }

    private boolean recordDeleted(IssueEvent event) {
        this.updatedIssues.remove(event.getIssue().getId());
        return this.deletedIssues.add(event.getIssue().getId());
    }
}

